/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.dashboard.widgets;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyFactory;
import com.teamscale.index.testgap.treemap.TreeMapNode;
import com.teamscale.index.user.UserAliasLookup;
import com.teamscale.service.dashboard.widgets.CodeOwnershipTreemapBuilder;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.metrics.treemap.TreemapQueryOptions;
import com.teamscale.service.metrics.treemap.TreemapServiceBase;
import com.teamscale.service.metrics.treemap.builder.TreeMapBuilderException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.ServiceUnavailableException;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/code-ownership/treemap")
public class CodeOwnershipTreemapService
extends TreemapServiceBase {
    @GET
    @Operation(summary="Get ownership treemap", description="Builds a code ownership treemap using the given parameters", tags={"Dashboards", "Treemap"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public TreeMapNode getCodeOwnershipTreemap(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @Parameter(description="Baseline commit to build code ownership treemap for") @QueryParam(value="baseline") UnresolvedCommitDescriptor baselineCommit, @Parameter(description="Uniform path to build a code city for", required=true, allowEmptyValue=true) @QueryParam(value="uniform-path") UniformPath uniformPath, @Parameter(description="Determines if import commits should be excluded") @QueryParam(value="exclude-merge-commits") boolean excludeImportCommits, @Parameter(description="Determines if merge commits should be excluded") @QueryParam(value="exclude-import-commits") boolean excludeMergeCommits, @BeanParam TreemapQueryOptions treemapParameters) throws StorageException, TreeMapBuilderException {
        if (!this.projectIndexExists("code-ownership")) {
            throw new ServiceUnavailableException("Code Ownership Analysis is not enabled in the analysis profile. Ask your project admin to enable it for you in the project's analysis profile's global settings.");
        }
        this.adjustTreemapQueryOptions(treemapParameters, uniformPath.getType());
        return this.computeTreemapNode(uniformPath, this.determineHistoryOption(commit), treemapParameters, baselineCommit, excludeMergeCommits, excludeImportCommits);
    }

    private TreeMapNode computeTreemapNode(UniformPath uniformPath, HistoryAccessOption historyAccessOption, TreemapQueryOptions treemapParameters, UnresolvedCommitDescriptor baselineCommit, boolean excludeMergeCommits, boolean excludeImportCommits) throws StorageException, TreeMapBuilderException {
        UserAliasLookup userAliasLookup = UserAliasLookup.createInstance((GlobalStorageSystem)this.getGlobalStorageSystem());
        IMetricRetrievalStrategy metricRetrievalStrategy = MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)uniformPath.getType(), (ProjectStorageSystem)this.getProjectStorageSystem(), (GlobalStorageSystem)this.getGlobalStorageSystem(), (User)this.getUser());
        CodeOwnershipTreemapBuilder ownershipTreemapBuilder = new CodeOwnershipTreemapBuilder(treemapParameters.includePattern, treemapParameters.excludePattern, metricRetrievalStrategy, historyAccessOption, treemapParameters.areaMetricIndex, treemapParameters.colorMetricDefaultValue, treemapParameters.baseColor, (ProjectStorageSystem)this.getProjectStorageSystem(), excludeMergeCommits, excludeImportCommits, userAliasLookup, this.resolve(baselineCommit).getTimestamp());
        return ownershipTreemapBuilder.buildTreeMap(uniformPath);
    }
}

