/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.external;

import com.google.common.base.Joiner;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.index.dependencies.TypeIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.LanguageGroups;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jetbrains.annotations.VisibleForTesting;

@Path(value="api/projects/{project}/jacoco-wizard")
public class JacocoAgentWizardService
extends ApiBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Path(value="packages")
    @Operation(summary="Get contained package names", description="All packages that should be profiled (subpackages will be profiled as well).")
    public List<String> getJavaProfilerJvmPackageNames(@PathParam(value="project") PublicProjectId projectId) throws StorageException {
        Set languages = AnalysisProfileUtils.getConfiguredLanguages((MetaIndex)this.getIndexLayer().openMetaIndex((IProjectId)projectId));
        if (CollectionUtils.intersectionSet((Collection)LanguageGroups.JVM_LANGUAGES, (Collection[])new Collection[]{languages}).isEmpty()) {
            throw new BadRequestException("The project " + String.valueOf(projectId) + " does not include any JVM languages.");
        }
        TypeIndex typeIndex = this.openProjectIndex(TypeIndex.class, HistoryAccessOption.readHead((String)this.getDefaultBranchName()));
        return JacocoAgentWizardService.guessIncludedPackages(typeIndex);
    }

    @VisibleForTesting
    static List<String> guessIncludedPackages(TypeIndex typeIndex) throws StorageException {
        Set<Package> packages = typeIndex.getUniformPathToTypesMap().entrySet().stream().filter(entry -> LanguageGroups.JVM_LANGUAGES.contains(ELanguage.fromPath((String)((String)entry.getKey())))).map(Map.Entry::getValue).flatMap(type -> type.getTypeNames().stream()).distinct().map(Package::new).collect(Collectors.toSet());
        return JacocoAgentWizardService.calculateIncludedPackages(packages);
    }

    @VisibleForTesting
    static List<String> calculateIncludedPackages(Set<Package> packages) {
        List filteredPackages = CollectionUtils.filter(packages, aPackage -> !aPackage.isDefaultPackage());
        if (filteredPackages.isEmpty()) {
            return Collections.emptyList();
        }
        Map<String, List<Package>> packagesByToplevelPrefix = filteredPackages.stream().collect(Collectors.groupingBy(aPackage -> aPackage.getPrefix(1)));
        ArrayList<String> result = new ArrayList<String>();
        for (List<Package> toplevelGroupedPackages : packagesByToplevelPrefix.values()) {
            result.addAll(JacocoAgentWizardService.calculateIncludedPackagesForToplevelPackage(toplevelGroupedPackages));
        }
        return result;
    }

    private static Set<String> calculateIncludedPackagesForToplevelPackage(List<Package> packages) {
        int minPrefixLength = packages.stream().mapToInt(Package::length).min().orElse(0);
        Set<String> prefixes = JacocoAgentWizardService.getPrefixes(packages, 1);
        for (int prefixLength = 2; prefixLength <= minPrefixLength; ++prefixLength) {
            Set<String> nextPrefixes = JacocoAgentWizardService.getPrefixes(packages, prefixLength);
            if (nextPrefixes.size() > 1) {
                return prefixes;
            }
            prefixes = nextPrefixes;
        }
        return prefixes;
    }

    private static Set<String> getPrefixes(List<Package> packages, int prefixLength) {
        return CollectionUtils.mapToSet(packages, aPackage -> aPackage.getPrefix(prefixLength));
    }

    @VisibleForTesting
    static class Package
    implements Comparable<Package> {
        private final List<String> parts;

        @VisibleForTesting
        Package(String typeName) {
            if (!typeName.contains(".")) {
                this.parts = Collections.emptyList();
            } else {
                String[] packages = typeName.split("[.]");
                this.parts = Arrays.asList(packages).subList(0, packages.length - 1);
            }
        }

        private boolean isDefaultPackage() {
            return this.parts.isEmpty();
        }

        private String getPrefix(int length) {
            int safeLength = Math.min(this.parts.size(), length);
            return Joiner.on((String)".").join(this.parts.subList(0, safeLength));
        }

        private int length() {
            return this.parts.size();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Package aPackage = (Package)other;
            return Objects.equals(this.parts, aPackage.parts);
        }

        public int hashCode() {
            return Objects.hash(this.parts);
        }

        public String toString() {
            return Joiner.on((String)".").join(this.parts);
        }

        @Override
        public int compareTo(Package other) {
            return this.toString().compareTo(other.toString());
        }
    }
}

