/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.issues;

import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptorBase;
import com.teamscale.index.issues.ICustomFieldsProvidingConnectorDescriptor;
import com.teamscale.index.issues.model.ExternalToolIssueCustomFieldResult;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.EComplexPermission;
import com.teamscale.service.framework.authorization.RequiresComplexPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/connectors/custom-fields")
public class ExternalToolIssueCustomFieldService
extends ApiBase {
    @PUT
    @Operation(summary="Get custom fields definitions", description="Returns the list of all available custom fields from the given connector", tags={"Connectors"})
    @RequiresComplexPermission(value=EComplexPermission.MAY_CONFIGURE_PROJECTS)
    public ExternalToolIssueCustomFieldResult getTrackerCustomFields(@RequestBody(required=true) ConnectorConfiguration connectorConfiguration) {
        try {
            ConnectorDescriptorBase connector = this.getConnectorDescriptor(connectorConfiguration);
            if (!(connector instanceof ICustomFieldsProvidingConnectorDescriptor)) {
                return new ExternalToolIssueCustomFieldResult("Service called with invalid connector descriptor: " + connector.getName());
            }
            ICustomFieldsProvidingConnectorDescriptor customFieldsProvidingConnector = (ICustomFieldsProvidingConnectorDescriptor)connector;
            return new ExternalToolIssueCustomFieldResult(customFieldsProvidingConnector.fetchCustomFields());
        }
        catch (ProjectConfigurationException | StorageException e) {
            return new ExternalToolIssueCustomFieldResult("Error while fetching custom fields from the given connector: " + e.getMessage());
        }
    }

    private ConnectorDescriptorBase getConnectorDescriptor(ConnectorConfiguration connectorConfiguration) throws StorageException, ProjectConfigurationException {
        GlobalStorageSystem globalStorageSystem = this.getGlobalStorageSystem();
        return ConnectorUtils.loadConnector((ConnectorConfiguration)connectorConfiguration, (ConfigurationInitializationContext)new ConfigurationInitializationContext(this.getIndexLayer(), (IExternalCredentialsProvider)globalStorageSystem.openGlobalIndex(ExternalCredentialsIndex.class)), null);
    }
}

