/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.logs;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.log.AuditLogs;
import com.teamscale.core.log.LogEntryIdentifier;
import com.teamscale.core.log.js.DetailedJavaScriptErrorLog;
import com.teamscale.core.log.js.ShortJavaScriptErrorLog;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.logging.LogFilteringParameters;
import com.teamscale.service.framework.logging.LogIndexesWrapper;
import com.teamscale.service.framework.logging.LogServiceUtils;
import com.teamscale.service.framework.logging.ProjectLogLevelFrequencies;
import com.teamscale.service.framework.logging.ShortLogResponse;
import com.teamscale.service.logs.IGlobalLogServiceApi;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/logs/javascript-errors")
public class JavascriptErrorsGlobalLogService
extends ApiBase
implements IGlobalLogServiceApi<ShortJavaScriptErrorLog, DetailedJavaScriptErrorLog> {
    static final String JAVASCRIPT_ERRORS_LOG_FILENAME = "TeamscaleJavaScriptErrorLogExport";

    @Override
    @Operation(summary="Get all JS error logs", description="Returns a list of all JavaScript error short logs.", tags={"Logging"}, operationId="getGlobalJavascriptErrorLogs")
    public ShortLogResponse<ShortJavaScriptErrorLog> getAllShortLogs(LogFilteringParameters logFilteringParameters) throws StorageException {
        return LogServiceUtils.getShortLogs((LogFilteringParameters)logFilteringParameters, JavascriptErrorsGlobalLogService.openJavascriptErrorLogIndexes(this.getIndexLayer()));
    }

    @Override
    @Operation(summary="Get JS error detail log", description="Returns the detailed JavaScript error log entry for the given timestamp.", tags={"Logging"}, operationId="getGlobalJavascriptErrorLog")
    public DetailedJavaScriptErrorLog getDetailedLog(LogEntryIdentifier id) throws StorageException {
        return (DetailedJavaScriptErrorLog)LogServiceUtils.getDetailedLogEntry(JavascriptErrorsGlobalLogService.openJavascriptErrorLogIndexes(this.getIndexLayer()), (LogEntryIdentifier)id);
    }

    @Override
    @Operation(summary="Get JS error frequencies", description="Returns the number of JavaScript error logs.", tags={"Logging"}, operationId="getGlobalJavascriptErrorLogFrequencies")
    public List<ProjectLogLevelFrequencies> getLogFrequencies() throws StorageException {
        return LogServiceUtils.obtainFrequencies(JavascriptErrorsGlobalLogService.openJavascriptErrorLogIndexes(this.getIndexLayer()));
    }

    @Override
    @Operation(summary="Download JS error logs", description="Returns a file download of the JavaScript error logs.", tags={"Logging"}, operationId="downloadGlobalJavascriptErrorLogs")
    public Response downloadLog(@BeanParam LogFilteringParameters logFilteringParameters, int maxChars) throws StorageException {
        return LogServiceUtils.createLogDownload((String)JAVASCRIPT_ERRORS_LOG_FILENAME, (LogFilteringParameters)logFilteringParameters, (int)maxChars, JavascriptErrorsGlobalLogService.openJavascriptErrorLogIndexes(this.getIndexLayer()));
    }

    @Override
    @Operation(summary="Delete JS error logs", description="Deletes all log entries that match the applied filters.", tags={"Logging"}, operationId="deleteGlobalJavascriptErrorLogs")
    public void deleteLogEntries(LogFilteringParameters logFilteringParameters) throws StorageException {
        LogServiceUtils.deleteLogEntries((LogFilteringParameters)logFilteringParameters, JavascriptErrorsGlobalLogService.openJavascriptErrorLogIndexes(this.getIndexLayer()));
        AuditLogs.globalLogDeletion((String)"JS error logs");
    }

    public static LogIndexesWrapper<ShortJavaScriptErrorLog, DetailedJavaScriptErrorLog> openJavascriptErrorLogIndexes(IndexLayer indexLayer) throws StorageException {
        return new LogIndexesWrapper(LogServiceUtils.getAllJavaScriptErrorLogIndexes((IndexLayer)indexLayer));
    }
}

