/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.logs;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.log.AuditLogs;
import com.teamscale.core.log.LogEntryIdentifier;
import com.teamscale.core.log.service.DetailedServiceLog;
import com.teamscale.core.log.service.ShortServiceLog;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.logging.LogFilteringParameters;
import com.teamscale.service.framework.logging.LogIndexesWrapper;
import com.teamscale.service.framework.logging.LogServiceUtils;
import com.teamscale.service.framework.logging.ProjectLogLevelFrequencies;
import com.teamscale.service.framework.logging.ShortLogResponse;
import com.teamscale.service.logs.IGlobalLogServiceApi;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

@Path(value="api/logs/service")
public class ServiceLogGlobalLogService
extends ApiBase
implements IGlobalLogServiceApi<ShortServiceLog, DetailedServiceLog> {
    static final String SERVICE_LOG_FILENAME = "TeamscaleServiceLogExport";

    @Override
    @Operation(summary="Get all service logs", description="Returns a list of all service short logs.", tags={"Logging"}, operationId="getGlobalServiceLogs")
    public ShortLogResponse<ShortServiceLog> getAllShortLogs(LogFilteringParameters logFilteringParameters) throws StorageException {
        return LogServiceUtils.getShortLogs((LogFilteringParameters)logFilteringParameters, ServiceLogGlobalLogService.openServiceLogIndexes(this.getIndexLayer()));
    }

    @Override
    @Operation(summary="Get service detail log", description="Returns the detailed service log entry for the given timestamp.", tags={"Logging"}, operationId="getGlobalServiceLog")
    public DetailedServiceLog getDetailedLog(LogEntryIdentifier logEntryIdentifier) throws StorageException {
        return (DetailedServiceLog)LogServiceUtils.getDetailedLogEntry(ServiceLogGlobalLogService.openServiceLogIndexes(this.getIndexLayer()), (LogEntryIdentifier)logEntryIdentifier);
    }

    @Override
    @Operation(summary="Get service log frequencies", description="Returns the frequencies of the various service log types (i.e. INFO/WARN/ERROR).", tags={"Logging"}, operationId="getGlobalServiceLogFrequencies")
    public List<ProjectLogLevelFrequencies> getLogFrequencies() throws StorageException {
        return LogServiceUtils.obtainFrequencies(ServiceLogGlobalLogService.openServiceLogIndexes(this.getIndexLayer()));
    }

    @Override
    @Operation(summary="Download service logs", description="Returns a file download of all service logs.", tags={"Logging"}, operationId="downloadGlobalServiceLogs")
    public Response downloadLog(@BeanParam LogFilteringParameters logFilteringParameters, int maxChars) throws StorageException {
        return LogServiceUtils.createLogDownload((String)SERVICE_LOG_FILENAME, (LogFilteringParameters)logFilteringParameters, (int)maxChars, ServiceLogGlobalLogService.openServiceLogIndexes(this.getIndexLayer()));
    }

    @Override
    @Operation(summary="Delete service logs", description="Deletes all log entries that match the applied filters.", tags={"Logging"}, operationId="deleteGlobalServiceLogs")
    public void deleteLogEntries(LogFilteringParameters logFilteringParameters) throws StorageException {
        LogServiceUtils.deleteLogEntries((LogFilteringParameters)logFilteringParameters, ServiceLogGlobalLogService.openServiceLogIndexes(this.getIndexLayer()));
        AuditLogs.globalLogDeletion((String)"service logs");
    }

    public static LogIndexesWrapper<ShortServiceLog, DetailedServiceLog> openServiceLogIndexes(IndexLayer indexLayer) throws StorageException {
        PairList allServiceLogIndexes = LogServiceUtils.getAllServiceLogIndexes((IndexLayer)indexLayer);
        return new LogIndexesWrapper(allServiceLogIndexes);
    }
}

