/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.distribution;

import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.schema.MetricSchemaRetrieverFactory;
import com.teamscale.core.metrics.values.EMetricValueType;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyFactory;
import com.teamscale.service.base.TimeRange;
import com.teamscale.service.base.TimeRangeResourceServiceBase;
import com.teamscale.service.base.TimeRangeResourceServiceQueryOptions;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.issues.IssueContributor;
import com.teamscale.service.metrics.distribution.MetricDistributionEntry;
import com.teamscale.service.metrics.distribution.MetricDistributionProvider;
import com.teamscale.service.metrics.distribution.MetricDistributionServiceQueryOptions;
import com.teamscale.service.metrics.distribution.MetricDistributionWithDelta;
import com.teamscale.service.requirements_tracing.SpecItemContributor;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/metric-distribution")
public class MetricDistributionService
extends TimeRangeResourceServiceBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class, SpecItemContributor.class, IssueContributor.class})
    @Operation(summary="Get metric distribution", description="Retrieves metric distributions for a resource sub-tree. A metric distribution can basically be thought of as a table which describes the distribution of a set of specified metrics with respect to a selected metric (called \"principal metric\") according to a set of given ranges (which are consecutive intervals based on a set of given boundaries).", tags={"Metrics", "Delta"}, responses={@ApiResponse(responseCode="400", description="Neither start timestamp nor time range provided."), @ApiResponse(responseCode="400", description="Provided end timestamp is smaller than start timestamp."), @ApiResponse(responseCode="400", description="Invalid metric index provided."), @ApiResponse(responseCode="400", description="Metric with provided index is not a numeric metric.")})
    public List<MetricDistributionEntry> getMetricDistribution(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @Parameter(description="Uniform path to obtain the metric distribution for", required=true, allowEmptyValue=true) @QueryParam(value="uniform-path") UniformPath uniformPath, @BeanParam MetricDistributionServiceQueryOptions metricDistributionParameters) throws StorageException {
        IMetricRetrievalStrategy metricRetrievalStrategy = MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)uniformPath.getType(), (ProjectStorageSystem)this.getProjectStorageSystem(), (GlobalStorageSystem)this.getGlobalStorageSystem(), (User)this.getUser(), (MetricSchemaRetrieverFactory)new MetricSchemaRetrieverFactory((ProjectStorageSystem)this.getProjectStorageSystem()));
        int principalMetricIndex = metricDistributionParameters.getPrincipalMetricIndex();
        MetricDistributionService.checkValidDoubleMetric(metricRetrievalStrategy.getMetricDirectorySchema(), principalMetricIndex);
        List<Integer> metricIndexes = metricDistributionParameters.getMetricIndexes();
        List<Double> boundaries = metricDistributionParameters.getBoundaries();
        return new MetricDistributionProvider().getMetricDistributionFor(uniformPath, metricRetrievalStrategy, this.determineHistoryOption(commit), principalMetricIndex, metricIndexes, boundaries);
    }

    @GET
    @Path(value="delta")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get metric distribution delta", description="Retrieves metrics distribution with deltas for a resource sub-tree. A metric distribution delta can basically be thought of as a table which describes the distribution of the delta for a set of specified metrics with respect to a selected metric delta (called \"principal metric delta\") according to a set of given ranges (which are consecutive intervals based on a set of given boundaries).", tags={"Metrics", "Delta"}, responses={@ApiResponse(responseCode="400", description="Neither start timestamp nor time range provided."), @ApiResponse(responseCode="400", description="Provided end timestamp is smaller than start timestamp."), @ApiResponse(responseCode="400", description="Invalid metric index provided."), @ApiResponse(responseCode="400", description="Metric with provided index is not a numeric metric.")})
    public MetricDistributionWithDelta getMetricDistributionDelta(@BeanParam TimeRangeResourceServiceQueryOptions timeRangeParameters, @BeanParam MetricDistributionServiceQueryOptions metricDistributionParameters) throws StorageException {
        TimeRange timeRange = this.createTimeRange(timeRangeParameters);
        HistoryAccessOption endHistoryOption = HistoryAccessOption.readCommit((CommitDescriptor)timeRange.end());
        HistoryAccessOption startHistoryOption = HistoryAccessOption.readCommit((CommitDescriptor)timeRange.start());
        IMetricRetrievalStrategy metricRetrievalStrategy = MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)timeRangeParameters.getUniformPath().getType(), (ProjectStorageSystem)this.getProjectStorageSystem(), (GlobalStorageSystem)this.getGlobalStorageSystem(), (User)this.getUser(), (MetricSchemaRetrieverFactory)new MetricSchemaRetrieverFactory((ProjectStorageSystem)this.getProjectStorageSystem()));
        int principalMetricIndex = metricDistributionParameters.getPrincipalMetricIndex();
        MetricDistributionService.checkValidDoubleMetric(metricRetrievalStrategy.getMetricDirectorySchema(), principalMetricIndex);
        List<Integer> metricIndexes = metricDistributionParameters.getMetricIndexes();
        List<Double> boundaries = metricDistributionParameters.getBoundaries();
        MetricDistributionProvider metricDistributionProvider = new MetricDistributionProvider();
        return metricDistributionProvider.getMetricDistributionWithDeltaFor(timeRangeParameters.getUniformPath(), metricRetrievalStrategy, startHistoryOption, endHistoryOption, principalMetricIndex, metricIndexes, boundaries);
    }

    private static void checkValidDoubleMetric(MetricDirectorySchema schema, int index) {
        if (index < 0 || index >= schema.getAllEntries().size()) {
            throw new BadRequestException("Invalid metric index  " + index);
        }
        if (((MetricDirectorySchemaEntry)schema.getAllEntries().get(index)).getValueType() != EMetricValueType.NUMERIC) {
            throw new BadRequestException("Metric with index " + index + " is not a numeric metric");
        }
    }
}

