/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.history;

import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.QueryParam;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;

public class MetricHistoryServiceQueryOptions {
    @QueryParam(value="start")
    @Parameter(description="The begin of the history range (in milliseconds since 1970). If not provided, begins with first available data.")
    private UnresolvedCommitDescriptor startCommit;
    @QueryParam(value="end")
    @Parameter(description="The end of the history range (in milliseconds since 1970). If not provided, end with current date.")
    private UnresolvedCommitDescriptor endCommit;
    @QueryParam(value="branch")
    @Parameter(description="Branch to retrieve metric history for")
    private String branch;
    @QueryParam(value="partition")
    @Parameter(description="The partitions to consider for metric retrieval")
    private Set<String> partitions;
    @QueryParam(value="all-partitions")
    @Parameter(description="Whether all partitions should be included")
    @DefaultValue(value="true")
    private boolean allPartitions;
    @QueryParam(value="max-milliseconds")
    @Parameter(description="The maximal number of milliseconds of history to return (backwards from the end). If the end timestamp is not defined, the end is fixed at the current date. Default is unlimited.")
    @DefaultValue(value="-1")
    private long length;

    public UnresolvedCommitDescriptor getStartCommit() {
        return this.startCommit;
    }

    public UnresolvedCommitDescriptor getEndCommit() {
        return this.endCommit;
    }

    public String getBranch() {
        return this.branch;
    }

    public long getLength() {
        return this.length;
    }

    public @Nullable Set<String> getPartitions() {
        if (this.allPartitions) {
            return null;
        }
        return this.partitions;
    }
}

