/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.treemap;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyFactory;
import com.teamscale.index.testgap.treemap.TreeMapNode;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.ReadCacheEnabled;
import com.teamscale.service.metrics.treemap.TreemapQueryOptions;
import com.teamscale.service.metrics.treemap.TreemapServiceBase;
import com.teamscale.service.metrics.treemap.builder.MatchedTypesTreeMapBuilder;
import com.teamscale.service.metrics.treemap.builder.MetricTreemapBuilderParameters;
import com.teamscale.service.metrics.treemap.builder.TreeMapBuilderException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.Set;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.uniformpath.UniformPath;

@ReadCacheEnabled
@Path(value="api/projects/{project}/matchedtypes/treemap")
public class MatchedTypesTreeMapService
extends TreemapServiceBase {
    @GET
    @Operation(summary="Get treemap for matched types", description="Builds a treemap for matched types.", tags={"Treemap"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public TreeMapNode getMatchedTypesTreemap(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @Parameter(description="Uniform path to build a treemap for", required=true, allowEmptyValue=true) @QueryParam(value="uniform-path") UniformPath uniformPath, @Parameter(description="Files that are matched by the component. These files will be colored in.", required=true) @QueryParam(value="matchedTypes") Set<String> matchedTypes, @BeanParam TreemapQueryOptions treemapParameters) throws StorageException, TreeMapBuilderException {
        try {
            this.adjustTreemapQueryOptions(treemapParameters, uniformPath.getType());
            return this.computeTreemapNode(treemapParameters, uniformPath, commit, matchedTypes);
        }
        catch (AssertionError e) {
            throw new BadRequestException("The chosen path \"" + String.valueOf(uniformPath) + "\" is an invalid choice!", (Throwable)((Object)e));
        }
    }

    private TreeMapNode computeTreemapNode(TreemapQueryOptions treemapParameters, UniformPath uniformPath, UnresolvedCommitDescriptor commit, Set<String> matchedTypes) throws TreeMapBuilderException, StorageException {
        MetricTreemapBuilderParameters parameters = new MetricTreemapBuilderParameters(treemapParameters.includePattern, treemapParameters.excludePattern, treemapParameters.colorMetricIndex, treemapParameters.colorMetricDefaultValue, treemapParameters.baseColor, treemapParameters.specifiedMinValue, treemapParameters.specifiedMaxValue, treemapParameters.isColorBlindModeEnabled());
        IMetricRetrievalStrategy metricRetrievalStrategy = MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)uniformPath.getType(), treemapParameters.getPartitions(), (ProjectStorageSystem)this.getProjectStorageSystem(), (GlobalStorageSystem)this.getGlobalStorageSystem(), (User)this.getUser());
        MatchedTypesTreeMapBuilder mapBuilder = new MatchedTypesTreeMapBuilder(metricRetrievalStrategy, this.determineHistoryOption(commit), treemapParameters.areaMetricIndex, parameters, matchedTypes);
        return mapBuilder.buildTreeMap(uniformPath);
    }
}

