/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.runtime.api.progress.EAnalysisState;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class ProjectsState {
    private static final String PROJECTS_PROPERTY = "projects";
    private static final String INITIAL_PROJECTS_PROPERTY = "initialProjects";
    private static final String PROJECT_STATES_PROPERTY = "projectStates";
    @JsonProperty(value="projects")
    private final List<PublicProjectId> projects;
    @JsonProperty(value="initialProjects")
    private final List<PublicProjectId> initialProjects;
    @JsonProperty(value="projectStates")
    private final Map<PublicProjectId, EAnalysisState> projectStates;

    @JsonCreator
    public ProjectsState(@JsonProperty(value="projectStates") Map<PublicProjectId, EAnalysisState> projectStates) {
        this.projectStates = CollectionUtils.asUnmodifiable(projectStates);
        this.projects = new ArrayList<PublicProjectId>();
        this.initialProjects = new ArrayList<PublicProjectId>();
        for (PublicProjectId project : projectStates.keySet()) {
            if (projectStates.get(project) == EAnalysisState.INITIAL_ANALYSIS) {
                this.initialProjects.add(project);
                continue;
            }
            this.projects.add(project);
        }
    }

    public UnmodifiableList<PublicProjectId> getProjects() {
        return CollectionUtils.asUnmodifiable(this.projects);
    }

    public UnmodifiableList<PublicProjectId> getInitialProjects() {
        return CollectionUtils.asUnmodifiable(this.initialProjects);
    }

    public Map<PublicProjectId, EAnalysisState> getProjectStates() {
        return this.projectStates;
    }
}

