/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.reports.slides;

import com.teamscale.core.index.IStorageInfo;
import com.teamscale.index.quality_report.slides.TasksSlide;
import com.teamscale.index.task.Task;
import com.teamscale.index.task.TaskIndex;
import com.teamscale.index.task.TaskUtils;
import com.teamscale.service.reports.ReportSlideWithRenderData;
import com.teamscale.service.reports.slides.SlideRenderContext;
import com.teamscale.service.reports.slides.SlideRendererBase;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.store.StorageException;

public class TasksSlideRenderer
extends SlideRendererBase<TasksSlide.TasksSlideParameters> {
    public TasksSlideRenderer(SlideRenderContext<TasksSlide.TasksSlideParameters> slideRenderContext) {
        super(slideRenderContext);
    }

    public TasksSlide.TasksSlideResult createSlideResult(@Nullable ReportSlideWithRenderData existingSlide) throws StorageException {
        IStorageInfo projectAwareStorageInfo = this.renderContext.resolveProjectAndReturnLocalStorageInfo(((TasksSlide.TasksSlideParameters)this.getParameters()).getProjectBranchPath());
        TaskIndex taskIndex = (TaskIndex)projectAwareStorageInfo.getProjectStorageSystem().openProjectIndex(TaskIndex.class, null);
        List tasks = taskIndex.getAllTasks();
        tasks = TasksSlideRenderer.filterTasksByBaselineRelation(tasks, ((TasksSlide.TasksSlideParameters)this.getParameters()).getBaselineRelation(), this.getReportProfile().getBaselineWithType().getTimestamp());
        List requestedStatuses = ((TasksSlide.TasksSlideParameters)this.getParameters()).getTaskStatuses();
        tasks = TaskUtils.filterTasksByStatus(tasks, new HashSet(requestedStatuses));
        tasks = tasks.stream().filter(task -> task.getTags().containsAll(((TasksSlide.TasksSlideParameters)this.getParameters()).getTaskTags())).sorted(Comparator.comparingInt(Task::getId)).collect(Collectors.toList());
        return new TasksSlide.TasksSlideResult(tasks, ((TasksSlide.TasksSlideParameters)this.getParameters()).getProjectBranchPath().getProjectId().toString(), this.getSlideCommentRenderData(((TasksSlide.TasksSlideParameters)this.getParameters()).getProjectBranchPath(), ((TasksSlide.TasksSlideParameters)this.getParameters()).getComments()));
    }

    private static List<Task> filterTasksByBaselineRelation(List<Task> tasks, List<TasksSlide.EBaselineRelation> baselineRelation, long reportTimestamp) {
        if (baselineRelation.isEmpty()) {
            return Collections.emptyList();
        }
        if (baselineRelation.size() == TasksSlide.EBaselineRelation.values().length) {
            return tasks;
        }
        return switch (baselineRelation.get(0)) {
            default -> throw new MatchException(null, null);
            case TasksSlide.EBaselineRelation.AFTER -> tasks.stream().filter(task -> task.getLastStatusUpdate() >= reportTimestamp).toList();
            case TasksSlide.EBaselineRelation.BEFORE -> tasks.stream().filter(task -> task.getLastStatusUpdate() < reportTimestamp).toList();
        };
    }
}

