/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.requirements_tracing;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.issue_reference.SpecItemCodeReference;
import com.teamscale.index.issue_reference.SpecItemCodeReferenceIndex;
import com.teamscale.index.tests.SpecItemTestReferenceIndex;
import com.teamscale.index.tests.TestExecutionIndex;
import com.teamscale.index.tests.TestExecutionWithPartition;
import com.teamscale.index.tests.TestImplementationPathToExecutionPathIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;

@Path(value="api/projects/{project}/spec-items/{id}/test-executions")
public class SpecItemTestService
extends ApiBase {
    @GET
    @Operation(summary="Get spec item test executions", description="Retrieves all test executions for tests that have a reference to the spec item.", tags={"Specification Items", "Tests"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<TestExecutionWithPartition> getSpecItemTestExecutions(@Parameter(description="ID of the spec item to fetch") @PathParam(value="id") String specItemId, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        HistoryAccessOption historyOption = this.determineHistoryOption(commit);
        SpecItemTestReferenceIndex specItemTestReferenceIndex = this.openProjectIndex(SpecItemTestReferenceIndex.class, historyOption);
        ArrayList keys = specItemTestReferenceIndex.getTestReference(specItemId);
        SpecItemCodeReferenceIndex specItemCodeReferenceIndex = this.openProjectIndex(SpecItemCodeReferenceIndex.class, historyOption);
        List codeReferences = specItemCodeReferenceIndex.getSpecItemCodeReferences(specItemId);
        TestExecutionIndex testExecutionIndex = this.openProjectIndex(TestExecutionIndex.class, historyOption);
        if (codeReferences != null) {
            List<String> testImplementationPaths = codeReferences.stream().map(SpecItemCodeReference::getTestImplementationUniformPath).filter(Objects::nonNull).sorted().distinct().toList();
            TestImplementationPathToExecutionPathIndex testImplementationPathToExecutionPathIndex = this.openProjectIndex(TestImplementationPathToExecutionPathIndex.class, historyOption);
            Set executionPaths = testImplementationPathToExecutionPathIndex.getExecutionPathsForImplementationPathsFlat(testImplementationPaths);
            List partitions = testExecutionIndex.getPartitions();
            for (String partition : partitions) {
                for (String testExecutionUniformPath : executionPaths) {
                    keys.add(new PartitionAndPath(partition, testExecutionUniformPath));
                }
            }
        }
        return CollectionUtils.filter((Collection)testExecutionIndex.getTestExecutionsForPartitionAndPaths((List)keys), Objects::nonNull);
    }
}

