/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.requirements_tracing.imported_links_resolution;

import com.teamscale.service.requirements_tracing.imported_links_resolution.ImportedLinksAndTypeResolution;
import com.teamscale.service.requirements_tracing.imported_links_resolution.SpecItemInfo;
import com.teamscale.service.requirements_tracing.imported_links_resolution.SpecItemLink;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssueId;
import com.teamscale.wia.TeamscaleIssueTypeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.conqat.engine.persistence.store.StorageException;

public class ImportedSpecItemLinksResolver {
    public static ImportedLinksAndTypeResolution resolve(ISpecItemResolver specItemResolver, SpecItem specItem) throws StorageException {
        Map<String, List<SpecItemLink>> resolvedSpecItemLinks = ImportedSpecItemLinksResolver.resolveLinks(specItemResolver, specItem);
        SpecItemInfo parentInfo = ImportedSpecItemLinksResolver.resolveParentInfos(specItemResolver, specItem);
        List<SpecItemInfo> additionalParentInfos = ImportedSpecItemLinksResolver.resolveAdditionalParentInfos(specItemResolver, specItem);
        additionalParentInfos.add(0, parentInfo);
        return new ImportedLinksAndTypeResolution(resolvedSpecItemLinks, additionalParentInfos);
    }

    public static List<ImportedLinksAndTypeResolution> resolve(ISpecItemResolver specItemResolver, Collection<? extends SpecItem> specItems) throws StorageException {
        ArrayList<ImportedLinksAndTypeResolution> resolutions = new ArrayList<ImportedLinksAndTypeResolution>(specItems.size());
        for (SpecItem specItem : specItems) {
            resolutions.add(ImportedSpecItemLinksResolver.resolve(specItemResolver, specItem));
        }
        return resolutions;
    }

    private static List<SpecItemInfo> resolveAdditionalParentInfos(ISpecItemResolver specItemResolver, SpecItem specItem) throws StorageException {
        List additionalParentIds = specItem.getAdditionalParents();
        List<SpecItem> additionalParents = specItemResolver.getSpecItemsByIds(additionalParentIds);
        ArrayList<SpecItemInfo> additionalParentInfos = new ArrayList<SpecItemInfo>();
        for (SpecItem parentItem : additionalParents) {
            SpecItemInfo parentInfo = parentItem == null ? new SpecItemInfo(null, null) : new SpecItemInfo(parentItem.getSubject(), parentItem.getTypeInfo());
            additionalParentInfos.add(parentInfo);
        }
        return additionalParentInfos;
    }

    private static SpecItemInfo resolveParentInfos(ISpecItemResolver specItemResolver, SpecItem specItem) throws StorageException {
        SpecItem parentSpecItem;
        TeamscaleIssueTypeInfo parentTypeInfo = null;
        String parentSubject = null;
        Optional parentId = specItem.getParentId();
        if (parentId.isPresent() && (parentSpecItem = specItemResolver.getSpecItemById((TeamscaleIssueId)parentId.get())) != null) {
            parentTypeInfo = parentSpecItem.getTypeInfo();
            parentSubject = parentSpecItem.getSubject();
        }
        return new SpecItemInfo(parentSubject, parentTypeInfo);
    }

    private static Map<String, List<SpecItemLink>> resolveLinks(ISpecItemResolver specItemResolver, SpecItem specItem) throws StorageException {
        List linkedSpecItemRoles = specItem.getLinkRoles();
        List linkedSpecItemIds = specItem.getLinkedSpecItems();
        HashMap<String, List<SpecItemLink>> resolvedSpecItemLinks = new HashMap<String, List<SpecItemLink>>();
        for (int i = 0; i < linkedSpecItemIds.size(); ++i) {
            if (((String)linkedSpecItemRoles.get(i)).equals("has parent") || ((List)linkedSpecItemIds.get(i)).isEmpty()) continue;
            List splitIds = (List)linkedSpecItemIds.get(i);
            List<SpecItem> linkedSpecItems = specItemResolver.getSpecItemsByIds(splitIds);
            for (int j = 0; j < splitIds.size(); ++j) {
                TeamscaleIssueId splitId = (TeamscaleIssueId)splitIds.get(j);
                SpecItem linkedSpecItem = linkedSpecItems.get(j);
                TeamscaleIssueTypeInfo linkedSpecItemTypeInfo = null;
                if (linkedSpecItem != null && linkedSpecItem.getTypeInfo() != null) {
                    linkedSpecItemTypeInfo = linkedSpecItem.getTypeInfo();
                }
                String linkedSpecItemSubject = null;
                if (linkedSpecItem != null) {
                    linkedSpecItemSubject = linkedSpecItem.getSubject();
                }
                SpecItemLink specItemLink = new SpecItemLink(splitId, (String)linkedSpecItemRoles.get(i), linkedSpecItem != null, linkedSpecItemTypeInfo, linkedSpecItemSubject);
                resolvedSpecItemLinks.computeIfAbsent(specItemLink.getRoleName(), ignored -> new ArrayList()).add(specItemLink);
            }
        }
        return resolvedSpecItemLinks;
    }

    @FunctionalInterface
    public static interface ISpecItemResolver {
        public List<SpecItem> getSpecItemsByIds(Collection<TeamscaleIssueId> var1) throws StorageException;

        default public SpecItem getSpecItemById(TeamscaleIssueId id) throws StorageException {
            return this.getSpecItemsByIds(List.of(id)).get(0);
        }
    }
}

