/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.resource;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.resource.resolution_strategy.IResourceResolutionStrategy;
import com.teamscale.index.resource.resolution_strategy.ResourceResolutionStrategyFactory;
import com.teamscale.index.resource.utils.EResourceType;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.framework.versioning.PublicApi;
import com.teamscale.service.issues.IssueContributor;
import com.teamscale.service.requirements_tracing.SpecItemContributor;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.Map;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class, IssueContributor.class, SpecItemContributor.class})
@Path(value="api/projects/{project}/resource-type")
public class ResourceTypeService
extends ApiBase {
    @PublicApi(since=ETeamscaleVersion.VERSION_6_4_0)
    @GET
    @Operation(summary="Get resource type", description="Retrieves the type of a resource represented by a uniform path.", tags={"Metrics"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public EResourceType getResourceType(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @Parameter(description="Uniform path to retrieve the resource type for", required=true, allowEmptyValue=true) @QueryParam(value="uniform-path") UniformPath uniformPath, @Parameter(description="Determines if the resource type should be searched in the default branch head in case not found for the given commit.") @QueryParam(value="check-default-branch") boolean checkDefaultBranch) throws StorageException {
        IResourceResolutionStrategy resourceResolutionStrategy = ResourceResolutionStrategyFactory.getStrategy((UniformPath)uniformPath, (ProjectStorageSystem)this.getProjectStorageSystem());
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        EResourceType resourceType = resourceResolutionStrategy.getResourceTypeForPath(uniformPath, historyAccessOption);
        HistoryAccessOption defaultBranchHead = this.readDefaultBranchHead();
        if (checkDefaultBranch && resourceType == EResourceType.UNKNOWN && !historyAccessOption.equals((Object)defaultBranchHead)) {
            return resourceResolutionStrategy.getResourceTypeForPath(uniformPath, defaultBranchHead);
        }
        return resourceType;
    }

    @GET
    @Path(value="children")
    @Operation(summary="Get children resource types", description="Retrieves the types of children of the resource represented by a uniform path. For children that are containers, this will be the type of their deepest relative path with more than one child", tags={"Metrics"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public Map<String, EResourceType> getChildrenResourceTypes(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @Parameter(description="Uniform path to retrieve the children resource types for", required=true, allowEmptyValue=true) @QueryParam(value="uniform-path") UniformPath uniformPath) throws StorageException {
        IResourceResolutionStrategy resourceResolutionStrategy = ResourceResolutionStrategyFactory.getStrategy((UniformPath)uniformPath, (ProjectStorageSystem)this.getProjectStorageSystem());
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        return resourceResolutionStrategy.getResourceChildTypesForPath(uniformPath, true, historyAccessOption);
    }
}

