/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.rest.MoreMediaTypes;
import com.teamscale.index.query.StoredQueryIndex;
import com.teamscale.index.resource.TokenElementLineInfoIndex;
import com.teamscale.index.testgap.MethodInfo;
import com.teamscale.index.testgap.MethodInfoIndex;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testimpact.CoverageUnitToMethodsMapIndex;
import com.teamscale.index.testimpact.MethodId;
import com.teamscale.index.testimpact.MethodIdIndex;
import com.teamscale.index.testimpact.MethodIdMap;
import com.teamscale.index.testimpact.MethodSet;
import com.teamscale.index.tests.TestHistoryIndex;
import com.teamscale.service.IteratorStreaming;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.util.ResponseUtils;
import com.teamscale.service.issues.QueryServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.StorageIterator;
import org.conqat.engine.persistence.store.StorageIterators;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.sourcecode.coverage.TestUniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.region.LineBasedRegion;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.string.LineOffsetConverter;
import org.conqat.lib.commons.string.LineOffsetUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

@Path(value="api/projects/{project}/test-query/executed-methods.csv")
public class MethodsExecutedByTestCaseService
extends QueryServiceBase {
    @GET
    @Operation(summary="Get methods executed by the queried tests", description="Returns all methods executed by the given test execution(s) matched by the given query, as a *.csv file.", tags={"Test Coverage"}, responses={@ApiResponse(responseCode="400", description="Could not process query.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Produces(value={"text/csv"})
    public Response getMethodsExecutedByTest(@QueryParam(value="query") @Parameter(required=true, allowEmptyValue=true) String query, @QueryParam(value="partition") @Parameter(description="The partitions to consider for the test executions") Set<String> partitions, @QueryParam(value="all-partitions") @Parameter(description="Whether all partitions should be included") @DefaultValue(value="true") boolean allPartitions, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor unresolvedCommit) throws StorageException {
        CommitDescriptor resolvedCommit = this.resolve(unresolvedCommit);
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readCommit((CommitDescriptor)resolvedCommit);
        TestHistoryIndex testHistoryIndex = this.openProjectIndex(TestHistoryIndex.class, historyAccessOption);
        List<String> queriedTests = MethodsExecutedByTestCaseService.performQueryWithErrorHandling(query, testHistoryIndex, historyAccessOption, StoredQueryIndex.EStoredQueryType.TEST, this.serviceInfo);
        Set queriedTestsExecutionPaths = queriedTests.stream().map(UniformPathCompatibilityUtil::convert).filter(UniformPath::isTestExecutionPath).collect(Collectors.toSet());
        CoverageUnitToMethodsMapIndex coverageIndex = this.openProjectIndex(CoverageUnitToMethodsMapIndex.class, historyAccessOption);
        Set<String> consideredPartitions = partitions;
        if (allPartitions) {
            consideredPartitions = new HashSet<String>(coverageIndex.getPartitions());
        }
        List partitionAndCoverageUnits = coverageIndex.resolveTestsWithCoverage(CollectionUtils.mapToSet(queriedTestsExecutionPaths, UniformPath::toString), consideredPartitions);
        MethodIdIndex methodIdIndex = this.openProjectIndex(MethodIdIndex.class, historyAccessOption);
        MethodInfoIndex methodInfoIndex = this.openProjectIndex(MethodInfoIndex.class, historyAccessOption);
        TokenElementLineInfoIndex tokenElementLineInfoIndex = this.openProjectIndex(TokenElementLineInfoIndex.class, historyAccessOption);
        StreamingOutput streamingOutput = IteratorStreaming.createCsvStreamFromStorageIterator(new String[]{"test", "file-path", "method-name", "start-line", "end-line"}, CsvRow::toArray, StorageIterators.flattenIterator((StorageIterator)StorageIterators.mapSequentially((StorageIterator)StorageIterators.makeBlockIterator((StorageIterator)StorageIterators.asStorageIterator((Iterable)partitionAndCoverageUnits), (int)100), tests -> MethodsExecutedByTestCaseService.getCsvRowsForTests(tests, coverageIndex, methodIdIndex, methodInfoIndex, tokenElementLineInfoIndex))));
        return ResponseUtils.getFileDownloadResponse((Object)streamingOutput, (MediaType)MoreMediaTypes.TEXT_CSV_TYPE, (String)"methods-executed-by-test.csv");
    }

    private static @NonNull List<CsvRow> getCsvRowsForTests(List<PartitionAndPath> tests, CoverageUnitToMethodsMapIndex coverageIndex, MethodIdIndex methodIdIndex, MethodInfoIndex methodInfoIndex, TokenElementLineInfoIndex tokenElementLineInfoIndex) throws StorageException {
        SetMap<UniformPath, MethodLocation> testedMethodsPerTest = MethodsExecutedByTestCaseService.getTestedMethods(tests, coverageIndex, methodIdIndex);
        return MethodsExecutedByTestCaseService.createCsvRowData(testedMethodsPerTest, methodInfoIndex, tokenElementLineInfoIndex);
    }

    private static SetMap<UniformPath, MethodLocation> getTestedMethods(List<PartitionAndPath> partitionAndCoverageUnits, CoverageUnitToMethodsMapIndex coverageIndex, MethodIdIndex methodIdIndex) throws StorageException {
        List methodSets = coverageIndex.getMethodSetsCoveredBy(partitionAndCoverageUnits);
        MethodIdMap methodIdMap = MethodsExecutedByTestCaseService.getMethodIdMap(methodSets, methodIdIndex);
        SetMap result = new SetMap();
        CollectionUtils.forEach(partitionAndCoverageUnits, (Iterable)methodSets, (partitionAndCoverageUnit, methodSet) -> {
            Set methodIds = methodSet.toSet();
            methodIds.stream().map(arg_0 -> ((MethodIdMap)methodIdMap).getMethodLocation(arg_0)).filter(Objects::nonNull).forEach(methodLocation -> result.add((Object)partitionAndCoverageUnit.toUniformPath(), methodLocation));
        });
        return result;
    }

    private static MethodIdMap getMethodIdMap(List<MethodSet> methodSets, MethodIdIndex methodIdIndex) throws StorageException {
        List<UniformPath> methodIdUniformPaths = methodSets.stream().map(MethodSet::toSet).flatMap(Collection::stream).map(MethodId::getUniformPath).toList();
        return methodIdIndex.getAllMappingsFor(methodIdUniformPaths);
    }

    private static List<CsvRow> createCsvRowData(SetMap<UniformPath, MethodLocation> testedMethodsPerTest, MethodInfoIndex methodInfoIndex, TokenElementLineInfoIndex tokenElementLineInfoIndex) throws StorageException {
        Map<MethodLocation, String> methodSimpleNames = MethodsExecutedByTestCaseService.getMethodSimpleNames(testedMethodsPerTest, methodInfoIndex);
        Map<String, LineOffsetConverter> lineOffsetConverterMap = MethodsExecutedByTestCaseService.prebuildExecutedMethodToLineOffsetConverterMap(tokenElementLineInfoIndex, CollectionUtils.mapToSet((Collection)testedMethodsPerTest.getValues(), MethodLocation::getUniformPath));
        ArrayList<CsvRow> csvRows = new ArrayList<CsvRow>();
        Set entries = testedMethodsPerTest.entrySet();
        for (Map.Entry entry : entries) {
            UniformPath testExecutionPath = (UniformPath)entry.getKey();
            Set testedMethods = (Set)entry.getValue();
            for (MethodLocation methodLocation : testedMethods) {
                String readableTestName = TestUniformPathUtils.convertCoverageUnitPathToTestName((String)testExecutionPath.toString());
                UniformPath executedMethodUniformPath = methodLocation.getUniformPath();
                String methodName = methodSimpleNames.get(methodLocation);
                Pair<Integer, Integer> startAndEndLine = MethodsExecutedByTestCaseService.getStartAndEndLine(methodLocation.getRegion(), lineOffsetConverterMap, executedMethodUniformPath.toStringAsMigrationFrontier());
                csvRows.add(new CsvRow(readableTestName, executedMethodUniformPath, methodName, (Integer)startAndEndLine.getFirst(), (Integer)startAndEndLine.getSecond()));
            }
        }
        return csvRows;
    }

    private static Map<MethodLocation, String> getMethodSimpleNames(SetMap<UniformPath, MethodLocation> testedMethodsPerTest, MethodInfoIndex methodInfoIndex) throws StorageException {
        HashSet methodLocations = new HashSet(testedMethodsPerTest.getValues());
        PairList methodInfosToQuery = new PairList();
        methodLocations.forEach(methodLocation -> methodInfosToQuery.add((Object)methodLocation.getUniformPath(), (Object)methodLocation.getRegion()));
        Map methodInfoMapForExactPaths = methodInfoIndex.getMethodInfoMapForExactPaths(methodInfosToQuery);
        return methodInfoMapForExactPaths.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((MethodInfo)e.getValue()).getMethodName()));
    }

    private static Map<String, LineOffsetConverter> prebuildExecutedMethodToLineOffsetConverterMap(TokenElementLineInfoIndex tokenElementLineInfoIndex, Set<UniformPath> executedMethodUniformPaths) throws StorageException {
        HashMap<String, LineOffsetConverter> lineOffsetConverterMap = new HashMap<String, LineOffsetConverter>();
        Map lineInfos = tokenElementLineInfoIndex.getLineInfosByPaths((Collection)UniformPathCompatibilityUtil.asUniformPathStrings(executedMethodUniformPaths));
        lineInfos.forEach((path, lineInfo) -> lineOffsetConverterMap.put((String)path, lineInfo.getRawLineOffsetConverter()));
        return lineOffsetConverterMap;
    }

    private static Pair<Integer, Integer> getStartAndEndLine(OffsetBasedRegion methodRegion, Map<String, LineOffsetConverter> lineOffsetConverterMap, String executedMethodUniformPath) {
        LineBasedRegion lineBasedRegion = LineOffsetUtils.convertToLineRegion((OffsetBasedRegion)methodRegion, (LineOffsetConverter)lineOffsetConverterMap.get(executedMethodUniformPath));
        return new Pair((Object)lineBasedRegion.getStart(), (Object)lineBasedRegion.getEnd());
    }

    private record CsvRow(String testName, UniformPath filePath, String methodName, int startLine, int endLine) {
        private String[] toArray() {
            return new String[]{this.testName, this.filePath.toString(), this.methodName, String.valueOf(this.startLine), String.valueOf(this.endLine)};
        }
    }
}

