/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.webhook;

import com.google.common.base.Preconditions;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.index.merge_request.MergeRequest;
import com.teamscale.index.merge_request.MergeRequestIndex;
import com.teamscale.index.merge_request.MergeRequestUpdateTriggerBase;
import com.teamscale.index.repository.git.azure_devops.AzureDevOpsGitMergeRequestUpdateTrigger;
import com.teamscale.index.repository.git.bitbucket.cloud.BitbucketCloudMergeRequestUpdateTrigger;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerMergeRequestUpdateTrigger;
import com.teamscale.index.repository.git.gitea.GiteaMergeRequestUpdateTrigger;
import com.teamscale.index.repository.git.github.GitHubMergeRequestUpdateTrigger;
import com.teamscale.index.repository.git.gitlab.GitLabMergeRequestUpdateTrigger;
import com.teamscale.index.repository.git.scm_manager.ScmManagerMergeRequestUpdateTrigger;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authentication.RequiresNoLogin;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;

@Path(value="api/projects/{project}/build-web-hook")
public class BuildStatusUpdateWebhookService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @POST
    @Operation(summary="Handles the incoming requests from code collaboration platforms signaling an update in the status of build jobs.", description="Handles the incoming requests from code collaboration platforms signaling the start or completion of a build job.The service identifies the merge request corresponding to the provided revision and triggers the merge request update process.", tags={"Voting Connectors"})
    @RequiresNoLogin
    public Response processBuildWebhookEvent(@QueryParam(value="revision") @Parameter(required=true, description="Git revision for which the build job is running.") String revision, @QueryParam(value="repository-url") @Parameter(required=true, description="Git repository URL for which the build job is running.") String repositoryUrl, @QueryParam(value="repository-platform") @Parameter(required=true, description="Git repository's platform. It must be one of [AZURE_DEVOPS_GIT, BITBUCKET, BITBUCKET_SERVER, GITEA, GITHUB, GITLAB, SCM_MANAGER]") ERepositoryConnector connectorType, @QueryParam(value="github-server-url") @Parameter(description="The URL the GitHub instance is reachable at. This parameter is required and used only if repository-platform is set to GITHUB.") String githubServerUrl) throws StorageException {
        BuildStatusUpdateWebhookService.checkRequiredArguments(revision, repositoryUrl, connectorType, githubServerUrl);
        Optional mergeRequest = this.openProjectIndex(MergeRequestIndex.class, null).getMergeRequest(revision);
        if (mergeRequest.isEmpty()) {
            String message = "Could not find a merge request corresponding to the provided revision: " + revision + " in project: " + String.valueOf(this.serviceInfo.getPrimaryPublicId());
            LOGGER.error(message);
            return Response.status((int)Response.Status.BAD_REQUEST.getStatusCode()).entity((Object)message).build();
        }
        this.scheduleMergeRequestUpdateTriggerForMergeRequest((MergeRequest)mergeRequest.get(), connectorType, githubServerUrl);
        return Response.ok().build();
    }

    private static void checkRequiredArguments(String revision, String repositoryUrl, ERepositoryConnector type, String githubServerUrl) {
        Preconditions.checkArgument((revision != null ? 1 : 0) != 0, (Object)"Revision parameter is required. Please provide a valid git revision.");
        Preconditions.checkArgument((repositoryUrl != null ? 1 : 0) != 0, (Object)"Repository URL parameter is required. Please provide a valid repository URL.");
        if (type == ERepositoryConnector.GITHUB) {
            Preconditions.checkArgument((githubServerUrl != null ? 1 : 0) != 0, (Object)"GitHub server URL is required for GitHub repositories.");
        }
    }

    private static Pair<Class<? extends MergeRequestUpdateTriggerBase<?, ?, ?>>, String> determineMergeRequestUpdateTriggerClassAndExtraParam(ERepositoryConnector ccp, String githubServerUrl) {
        return switch (ccp) {
            case ERepositoryConnector.AZURE_DEVOPS_GIT -> Pair.createPair(AzureDevOpsGitMergeRequestUpdateTrigger.class, null);
            case ERepositoryConnector.BITBUCKET -> Pair.createPair(BitbucketCloudMergeRequestUpdateTrigger.class, null);
            case ERepositoryConnector.BITBUCKET_SERVER -> Pair.createPair(BitbucketServerMergeRequestUpdateTrigger.class, null);
            case ERepositoryConnector.GITEA -> Pair.createPair(GiteaMergeRequestUpdateTrigger.class, null);
            case ERepositoryConnector.GITHUB -> Pair.createPair(GitHubMergeRequestUpdateTrigger.class, (Object)githubServerUrl);
            case ERepositoryConnector.GITLAB -> Pair.createPair(GitLabMergeRequestUpdateTrigger.class, null);
            case ERepositoryConnector.SCM_MANAGER -> Pair.createPair(ScmManagerMergeRequestUpdateTrigger.class, null);
            default -> throw new IllegalArgumentException("Unsupported connector type: " + String.valueOf(ccp) + ". It must be one of [AZURE_DEVOPS_GIT, BITBUCKET, BITBUCKET_SERVER, GITEA, GITHUB, GITLAB, SCM_MANAGER]");
        };
    }

    private void scheduleMergeRequestUpdateTriggerForMergeRequest(MergeRequest mergeRequest, ERepositoryConnector connectorType, String githubServerUrl) {
        Pair<Class<? extends MergeRequestUpdateTriggerBase<?, ?, ?>>, String> jobTriggerClassAndExtraParam = BuildStatusUpdateWebhookService.determineMergeRequestUpdateTriggerClassAndExtraParam(connectorType, githubServerUrl);
        @Nullable String extraParam = (String)jobTriggerClassAndExtraParam.getSecond();
        MergeRequestUpdateTriggerBase.JobParameter parameter = new MergeRequestUpdateTriggerBase.JobParameter(mergeRequest.identifier, false, extraParam);
        JobDescriptor job = new JobDescriptor(this.serviceInfo.getInternalId(), (Class)jobTriggerClassAndExtraParam.getFirst(), null, (Object)parameter, "Update for build job status belonging to merge request '" + mergeRequest.identifier.id + "' received via web hook.");
        try {
            ISchedulerCommunicator.getInstance().scheduleExternalJob(this.getIndexLayer(), job);
        }
        catch (StorageException e) {
            LOGGER.error("Failed to run build job update belonging to merge request " + mergeRequest.identifier.id + " in repository " + mergeRequest.getRepositoryName(), (Throwable)e);
        }
    }
}

