/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.ui;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkPropagatedSignalLabels;
import org.conqat.lib.simulink.model.SimulinkResolvedDataTypes;
import org.conqat.lib.simulink.model.datahandler.LabelLayoutData;
import org.conqat.lib.simulink.model.datahandler.LineLayoutData;
import org.conqat.lib.simulink.model.datahandler.simulink.SimulinkLayoutHandler;
import org.conqat.lib.simulink.model.datahandler.simulink.SimulinkLineLayoutUtils;

public class SimulinkLineUIData {
    private static final String LINE_LAYOUT_DATA_PROPERTY = "lineLayoutData";
    private static final String ID_PROPERTY = "id";
    private static final String NAME_LABEL_LAYOUT_DATA_PROPERTY = "nameLabelLayoutData";
    private static final String TYPE_LABEL_LAYOUT_DATA_PROPERTY = "typeLabelLayoutData";
    @JsonProperty(value="lineLayoutData")
    private LineLayoutData lineLayoutData;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="nameLabelLayoutData")
    private final @Nullable LabelLayoutData nameLabelLayoutData;
    @JsonProperty(value="typeLabelLayoutData")
    private final @Nullable LabelLayoutData typeLabelLayoutData;

    @JsonCreator
    public SimulinkLineUIData(@JsonProperty(value="lineLayoutData") LineLayoutData lineLayoutData, @JsonProperty(value="id") String id, @JsonProperty(value="nameLabelLayoutData") @Nullable LabelLayoutData nameLabelLayoutData, @JsonProperty(value="typeLabelLayoutData") @Nullable LabelLayoutData typeLabelLayoutData) {
        this.lineLayoutData = lineLayoutData;
        this.id = id;
        this.nameLabelLayoutData = nameLabelLayoutData;
        this.typeLabelLayoutData = typeLabelLayoutData;
    }

    public SimulinkLineUIData(SimulinkLine line, SimulinkPropagatedSignalLabels propagatedSignalLabels, SimulinkResolvedDataTypes propagatedDataTypes) {
        this.lineLayoutData = line.obtainLayoutData();
        this.id = SimulinkLineUIData.obtainArtificialId(line);
        List<LabelLayoutData> layoutDatas = SimulinkLineLayoutUtils.extractLineLabelLayoutData(line, this.lineLayoutData, SimulinkLayoutHandler.extractFontData(line), propagatedSignalLabels);
        this.nameLabelLayoutData = layoutDatas.isEmpty() ? null : layoutDatas.get(0);
        this.typeLabelLayoutData = SimulinkLineLayoutUtils.extractTypeLabelLayoutData(line, this.lineLayoutData, SimulinkLayoutHandler.extractFontData(line), propagatedDataTypes);
    }

    public static String obtainArtificialId(SimulinkLine line) {
        StringBuilder builder = new StringBuilder();
        builder.append(line.getContainer().getId());
        builder.append("/");
        if (line.getSrcPort() != null) {
            builder.append(line.getSrcPort().getBlock().getName() + ":" + line.getSrcPort().getIndex());
        } else {
            builder.append("<no-src>");
        }
        builder.append("->");
        if (line.getDstPort() != null) {
            builder.append(line.getDstPort().getBlock().getName() + ":" + line.getDstPort().getIndex());
        } else {
            builder.append(line.getParameter("Points"));
            builder.append("<no-dst>");
        }
        return builder.toString();
    }

    public String getId() {
        return this.id;
    }

    public LineLayoutData getLineLayoutData() {
        return this.lineLayoutData;
    }
}

