/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cross_language;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-test-for-nan-correctly", languages={ELanguage.CS, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.JAVA, ELanguage.JAVASCRIPT, ELanguage.PYTHON}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class TestForNaNCorrectlyCheck
extends CheckImplementationBase {
    private static final ITokenMatcher HANDLED_COMPARISON_OPERATORS_JAVASCRIPT = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EQEQ, ETokenType.NOTEQ, ETokenType.EQEQEQ, ETokenType.NOTEQEQ});
    private static final ITokenMatcher HANDLED_COMPARISON_OPERATORS_CLIKE = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EQEQ, ETokenType.NOTEQ});
    private static final Map<ELanguage, Set<String[]>> NAN_SEQUENCES = new HashMap<ELanguage, Set<String[]>>();

    public void execute() throws CheckException {
        List selectedEntities = ShallowEntityTraversalUtils.listEntitiesOfTypes((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), EnumSet.of(EShallowEntityType.STATEMENT, EShallowEntityType.ATTRIBUTE));
        for (ShallowEntity selectedEntity : selectedEntities) {
            this.processTokens((List<IToken>)selectedEntity.ownStartTokens());
            this.processTokens((List<IToken>)selectedEntity.ownEndTokens());
        }
    }

    private void processTokens(List<IToken> tokens) throws CheckException {
        ELanguage language = this.context.getLanguage();
        if (!NAN_SEQUENCES.containsKey(language)) {
            CCSMAssert.fail((String)("Language is not supported by check: " + String.valueOf(language)));
        }
        Set<String[]> nanSequences = NAN_SEQUENCES.get(language);
        ITokenMatcher operators = TestForNaNCorrectlyCheck.getHandledComparisonOperators(language);
        List operatorIndices = TokenStreamUtils.findAll(tokens, (ITokenMatcher)operators);
        for (Integer operatorIndex : operatorIndices) {
            for (String[] nanSequence : nanSequences) {
                this.checkComparisonOperandsForNaN(tokens, operatorIndex, nanSequence);
            }
        }
    }

    private static ITokenMatcher getHandledComparisonOperators(ELanguage language) {
        if (language == ELanguage.JAVASCRIPT) {
            return HANDLED_COMPARISON_OPERATORS_JAVASCRIPT;
        }
        return HANDLED_COMPARISON_OPERATORS_CLIKE;
    }

    private void checkComparisonOperandsForNaN(List<IToken> tokens, int operatorIndex, String[] nanSequence) {
        int rightOperandIndex;
        int leftOperandIndex = operatorIndex - nanSequence.length;
        if (!(leftOperandIndex >= 0 && this.checkIndexForNaN(tokens, leftOperandIndex, nanSequence) || (rightOperandIndex = operatorIndex + 1) >= tokens.size())) {
            this.checkIndexForNaN(tokens, rightOperandIndex, nanSequence);
        }
    }

    private boolean checkIndexForNaN(List<IToken> tokens, int index, String[] nanSequence) {
        if (TokenStreamTextUtils.hasSequence(tokens, (int)index, (String[])nanSequence)) {
            this.buildFinding("Value should not be tested against `" + StringUtils.concat((Object[])nanSequence, (String)"") + "`", this.buildLocation().forToken(tokens.get(index))).createAndStore();
            return true;
        }
        return false;
    }

    static {
        NAN_SEQUENCES.put(ELanguage.CS, CollectionUtils.asHashSet((Object[])new String[][]{{"Single", ".", "NaN"}, {"Double", ".", "NaN"}}));
        NAN_SEQUENCES.put(ELanguage.CPP, CollectionUtils.asHashSet((Object[])new String[][]{{"NAN"}}));
        NAN_SEQUENCES.put(ELanguage.CPP_MS_CLI, CollectionUtils.asHashSet((Object[])new String[][]{{"NAN"}}));
        NAN_SEQUENCES.put(ELanguage.C, CollectionUtils.asHashSet((Object[])new String[][]{{"NAN"}}));
        NAN_SEQUENCES.put(ELanguage.JAVA, CollectionUtils.asHashSet((Object[])new String[][]{{"Float", ".", "NaN"}, {"Double", ".", "NaN"}}));
        NAN_SEQUENCES.put(ELanguage.JAVASCRIPT, CollectionUtils.asHashSet((Object[])new String[][]{{"NaN"}}));
        NAN_SEQUENCES.put(ELanguage.PYTHON, CollectionUtils.asHashSet((Object[])new String[][]{{"float", "(", "'nan'", ")"}, {"float", "(", "\"nan\"", ")"}}));
    }
}

