/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-number-of-constructors", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class NumberOfConstructorsCheck
extends CheckImplementationBase {
    @CheckOption(name="Maximum number of constructors", description="The maximum number of constructors that are allowed.")
    private int maximumNumberOfConstructors = 5;

    public void execute() throws CheckException {
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity type : types) {
            this.processEntity(type);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        int actualNumberOfConstructors = NumberOfConstructorsCheck.select((ShallowEntity)entity, (String)"METHOD[subtype('constructor')]").size();
        if (actualNumberOfConstructors > this.maximumNumberOfConstructors) {
            this.buildFinding("Too many constructors (" + actualNumberOfConstructors + "/" + this.maximumNumberOfConstructors + ")", this.buildLocation().forEntityFirstLine(entity)).createAndStore();
        }
    }
}

