/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.jetbrains.annotations.VisibleForTesting;

@Check(id="cqse.maab.na_0003", languages={ELanguage.SIMULINK})
public class SimulinkConditionsInIfBlocksCheck
extends CheckImplementationBase {
    private static final EnumSet<ETokenType> LOGICAL_OPERATORS = EnumSet.of(ETokenType.AND, ETokenType.OR, ETokenType.XOR, ETokenType.ANDAND, ETokenType.OROR);
    private static final TokenPattern COMPARISON_OPERATORS = new TokenPattern().alternative(new Object[]{ETokenType.LT, ETokenType.LTEQ, ETokenType.GT, ETokenType.GTEQ, ETokenType.EQEQ, ETokenType.NOTEQ});
    private static final TokenPattern QUALIFIED_IDENTIFIER = new TokenPattern().sequence(new Object[]{ETokenType.ETokenClass.IDENTIFIER}).repeated(new Object[]{ETokenType.DOT, ETokenType.ETokenClass.IDENTIFIER});
    private static final TokenPattern LITERAL_OR_IDENTIFIER_WITH_OPTIONAL_NEGATION = new TokenPattern().optional(new Object[]{ETokenType.COMP}).alternative(new Object[]{ETokenType.ETokenClass.LITERAL, QUALIFIED_IDENTIFIER});
    private static final TokenPattern SIMPLE_COMPARISON = new TokenPattern().sequence(new Object[]{LITERAL_OR_IDENTIFIER_WITH_OPTIONAL_NEGATION}).optional(new Object[]{COMPARISON_OPERATORS, LITERAL_OR_IDENTIFIER_WITH_OPTIONAL_NEGATION});
    private static final TokenPattern PARENTHESIS_PRIMARY_EXPRESSION = new TokenPattern().sequence(new Object[]{ETokenType.LPAREN, SIMPLE_COMPARISON, ETokenType.RPAREN});
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Consider simplifying the condition by extracting part of it to an input");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, Collections.singleton("If"), (boolean)false, (boolean)false)) {
            ArrayList<String> expressions = new ArrayList<String>();
            expressions.add(block.getParameter("IfExpression"));
            String elseIfCondition = block.getParameter("ElseIfExpressions");
            if (elseIfCondition != null) {
                expressions.addAll(Arrays.asList(block.getParameter("ElseIfExpressions").split(",")));
            }
            for (String conditionalExpression : expressions) {
                Optional<String> message = SimulinkConditionsInIfBlocksCheck.checkConditionalExpression(conditionalExpression, this.context.getUniformPath());
                if (!message.isPresent()) continue;
                this.buildFinding(message.get(), (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
            }
        }
    }

    @VisibleForTesting
    static Optional<String> checkConditionalExpression(String conditionalExpression, String parsingOrigin) {
        if (conditionalExpression == null) {
            return Optional.empty();
        }
        List<IToken> tokens = ScannerUtils.getTokens((String)conditionalExpression, (ELanguage)ELanguage.MATLAB, (String)parsingOrigin);
        tokens = TokenStreamUtils.removeAtEnd((List)tokens, (ETokenType)ETokenType.EOL);
        List subExpressions = TokenStreamUtils.splitWithNesting(tokens = SimulinkConditionsInIfBlocksCheck.removeOuterParenthesesIfNecessary(tokens), LOGICAL_OPERATORS, Collections.singletonList(ETokenType.LPAREN), Collections.singletonList(ETokenType.RPAREN), (int)Integer.MAX_VALUE);
        if (subExpressions.size() == 1 && SIMPLE_COMPARISON.matchFully((List)subExpressions.get(0)) != null) {
            return Optional.empty();
        }
        Optional<String> message = SimulinkConditionsInIfBlocksCheck.checkWhetherAllSubExpressionsArePrimaryExpressions(subExpressions);
        if (message.isPresent()) {
            return message;
        }
        if (subExpressions.size() <= 2) {
            return Optional.empty();
        }
        if (!SimulinkConditionsInIfBlocksCheck.allOperatorTypesAreEqual(subExpressions, tokens)) {
            return Optional.of("Two different operator types between primary expressions in if block");
        }
        if (!SimulinkConditionsInIfBlocksCheck.allPrimaryExpressionsAreInputs(subExpressions)) {
            return Optional.of("Too many primary expressions in condition of if block are not simple inputs");
        }
        return Optional.empty();
    }

    private static @NonNull List<IToken> removeOuterParenthesesIfNecessary(List<IToken> tokens) {
        List tokensBetween = TokenStreamUtils.tokensBetweenWithNesting(tokens, (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
        if (!tokensBetween.isEmpty() && tokensBetween.size() == tokens.size() - 2) {
            tokens = TokenStreamUtils.removeAtFront(tokens, (ETokenType)ETokenType.LPAREN);
            tokens = TokenStreamUtils.removeAtEnd((List)tokens, (ETokenType)ETokenType.RPAREN);
        }
        return tokens;
    }

    private static boolean allPrimaryExpressionsAreInputs(List<List<IToken>> subExpressions) {
        for (List<IToken> subExpression : subExpressions) {
            if (LITERAL_OR_IDENTIFIER_WITH_OPTIONAL_NEGATION.matchFully(subExpression = SimulinkConditionsInIfBlocksCheck.removeOuterParenthesesIfNecessary(subExpression)) != null) continue;
            return false;
        }
        return true;
    }

    private static boolean allOperatorTypesAreEqual(List<List<IToken>> subExpressions, List<IToken> originalTokens) {
        ETokenType operatorType = null;
        int tokenIndex = 0;
        for (List<IToken> subExpression : subExpressions) {
            if ((tokenIndex += subExpression.size()) >= originalTokens.size()) {
                return true;
            }
            ETokenType currentOperatorType = originalTokens.get(tokenIndex).getType();
            ++tokenIndex;
            if (operatorType != null) {
                if (currentOperatorType == operatorType) continue;
                return false;
            }
            operatorType = currentOperatorType;
        }
        return true;
    }

    private static Optional<String> checkWhetherAllSubExpressionsArePrimaryExpressions(List<List<IToken>> subExpressions) {
        for (List<IToken> subExpression : subExpressions) {
            if (subExpression.isEmpty()) {
                return Optional.empty();
            }
            if (PARENTHESIS_PRIMARY_EXPRESSION.matchFully(subExpression) != null || LITERAL_OR_IDENTIFIER_WITH_OPTIONAL_NEGATION.matchFully(subExpression) != null) continue;
            return Optional.of("Invalid primary expression " + MarkupUtils.formatAsSourceCode((String)TokenStreamTextUtils.concatTokenTexts(subExpression)) + " in if condition");
        }
        return Optional.empty();
    }
}

