/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.phpini;

import java.util.Locale;
import java.util.Set;
import org.sonar.php.ini.tree.Directive;

public enum PhpIniBoolean {
    ON("1", "ON", "TRUE", "YES"),
    OFF("0", "OFF", "FALSE", "NO");

    private final Set<String> variants;

    private PhpIniBoolean(String ... variants) {
        this.variants = Set.of(variants);
    }

    public boolean matchesValue(Directive directive) {
        return this.matchesValue(directive.value().text());
    }

    public boolean matchesValue(String rawValue) {
        String value = rawValue;
        if (PhpIniBoolean.isQuotedValue(value, "\"") || PhpIniBoolean.isQuotedValue(value, "'")) {
            value = value.substring(1, value.length() - 1);
        }
        return this.variants.contains(value.toUpperCase(Locale.ENGLISH));
    }

    private static boolean isQuotedValue(String value, String quote) {
        return value.startsWith(quote) && value.endsWith(quote);
    }
}

