/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.symbols;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sonar.plugins.php.api.symbols.Symbol;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;

public class Scope {
    private final Scope outer;
    private final Tree tree;
    protected List<Symbol> symbols = new ArrayList<Symbol>();
    Scope superClassScope;
    private boolean unresolvedCompact;
    private boolean captureOuterScope;

    public Scope(Scope outer, Tree tree, boolean captureOuterScope) {
        this.outer = Objects.requireNonNull(outer);
        this.tree = Objects.requireNonNull(tree);
        this.captureOuterScope = captureOuterScope;
    }

    public Scope(CompilationUnitTree compilationUnitTree) {
        this.outer = null;
        this.tree = compilationUnitTree;
        this.captureOuterScope = false;
    }

    public Tree tree() {
        return this.tree;
    }

    public Scope outer() {
        return this.outer;
    }

    public List<Symbol> getSymbols(Symbol.Kind kind) {
        LinkedList<Symbol> result = new LinkedList<Symbol>();
        for (Symbol symbol : this.symbols) {
            if (!symbol.is(kind)) continue;
            result.add(symbol);
        }
        return result;
    }

    public boolean isGlobal() {
        return this.tree.is(Tree.Kind.COMPILATION_UNIT);
    }

    public void addSymbol(Symbol symbol) {
        this.symbols.add(symbol);
    }

    @Nullable
    public Symbol getSymbol(String name, Symbol.Kind ... kinds) {
        List<Symbol.Kind> kindList = Arrays.asList(kinds);
        ArrayList<Symbol> result = new ArrayList<Symbol>();
        for (Symbol s : this.symbols) {
            if (!s.called(name)) continue;
            if (kindList.isEmpty() || kindList.contains((Object)s.kind())) {
                result.add(s);
                continue;
            }
            if (!s.is(Symbol.Kind.PARAMETER) || !kindList.equals(Collections.singletonList(Symbol.Kind.VARIABLE))) continue;
            return null;
        }
        if (result.isEmpty()) {
            if (this.superClassScope != null) {
                return this.superClassScope.getSymbol(name, kinds);
            }
            if (this.captureOuterScope) {
                return this.outer.getSymbol(name, kinds);
            }
        }
        return result.size() == 1 ? (Symbol)result.get(0) : null;
    }

    void setUnresolvedCompact(boolean unresolvedCompact) {
        this.unresolvedCompact = unresolvedCompact;
    }

    public boolean hasUnresolvedCompact() {
        return this.unresolvedCompact;
    }
}

