/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.reports.psalm;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.sonar.plugins.php.reports.JsonReportReader;
import org.sonarsource.analyzer.commons.internal.json.simple.JSONArray;
import org.sonarsource.analyzer.commons.internal.json.simple.JSONObject;
import org.sonarsource.analyzer.commons.internal.json.simple.parser.ParseException;

public class PsalmJsonReportReader
extends JsonReportReader {
    private final Consumer<JsonReportReader.Issue> consumer;

    private PsalmJsonReportReader(Consumer<JsonReportReader.Issue> consumer) {
        this.consumer = consumer;
    }

    static void read(InputStream in, Consumer<JsonReportReader.Issue> consumer) throws IOException, ParseException {
        new PsalmJsonReportReader(consumer).read(in);
    }

    private void read(InputStream in) throws IOException, ParseException {
        JSONObject rootObject = (JSONObject)this.jsonParser.parse(new InputStreamReader(in, StandardCharsets.UTF_8));
        JSONArray issues = (JSONArray)rootObject.get("issues");
        if (issues != null) {
            issues.stream().forEach(this::onIssue);
        }
    }

    private void onIssue(JSONObject i) {
        JSONObject primaryLocation = (JSONObject)i.get("primaryLocation");
        if (primaryLocation != null) {
            JsonReportReader.Issue issue = new JsonReportReader.Issue();
            issue.ruleId = (String)i.get("ruleId");
            issue.filePath = (String)primaryLocation.get("filePath");
            issue.message = (String)primaryLocation.get("message");
            JSONObject textRange = (JSONObject)primaryLocation.get("textRange");
            if (textRange != null) {
                issue.startLine = PsalmJsonReportReader.toInteger(textRange.get("startLine"));
                issue.startColumn = PsalmJsonReportReader.toInteger(textRange.get("startColumn"));
                issue.endLine = PsalmJsonReportReader.toInteger(textRange.get("endLine"));
                issue.endColumn = PsalmJsonReportReader.toInteger(textRange.get("endColumn"));
            }
            issue.type = (String)i.get("type");
            issue.severity = (String)i.get("severity");
            this.consumer.accept(issue);
        }
    }
}

