/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.matchers;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.api.Trivia;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonar.sslr.internal.grammar.MutableParsingRule;
import org.sonar.sslr.internal.matchers.LocatedText;
import org.sonar.sslr.internal.matchers.ParseNode;
import org.sonar.sslr.internal.matchers.TextLocation;
import org.sonar.sslr.internal.vm.TokenExpression;
import org.sonar.sslr.internal.vm.TriviaExpression;
import org.sonar.sslr.parser.ParsingResult;

public final class AstCreator {
    private static final URI FAKE_URI;
    private final LocatedText input;
    private final Token.Builder tokenBuilder = Token.builder();
    private final List<Trivia> trivias = new ArrayList<Trivia>();
    static final TokenType UNDEFINED_TOKEN_TYPE;

    public static AstNode create(ParsingResult parsingResult, LocatedText input) {
        AstNode astNode = new AstCreator(input).visit(parsingResult.getParseTreeRoot());
        astNode.hasToBeSkippedFromAst();
        return astNode;
    }

    private AstCreator(LocatedText input) {
        this.input = input;
    }

    private AstNode visit(ParseNode node) {
        if (node.getMatcher() instanceof MutableParsingRule) {
            return this.visitNonTerminal(node);
        }
        return this.visitTerminal(node);
    }

    private AstNode visitTerminal(ParseNode node) {
        if (node.getMatcher() instanceof TriviaExpression) {
            TriviaExpression ruleMatcher = (TriviaExpression)node.getMatcher();
            if (ruleMatcher.getTriviaKind() == Trivia.TriviaKind.SKIPPED_TEXT) {
                return null;
            }
            if (ruleMatcher.getTriviaKind() == Trivia.TriviaKind.COMMENT) {
                this.updateTokenPositionAndValue(node);
                this.tokenBuilder.setTrivia(Collections.emptyList());
                this.tokenBuilder.setType(GenericTokenType.COMMENT);
                this.trivias.add(Trivia.createComment(this.tokenBuilder.build()));
                return null;
            }
            throw new IllegalStateException("Unexpected trivia kind: " + (Object)((Object)ruleMatcher.getTriviaKind()));
        }
        if (node.getMatcher() instanceof TokenExpression) {
            this.updateTokenPositionAndValue(node);
            TokenExpression ruleMatcher = (TokenExpression)node.getMatcher();
            this.tokenBuilder.setType(ruleMatcher.getTokenType());
            if (ruleMatcher.getTokenType() == GenericTokenType.COMMENT) {
                this.tokenBuilder.setTrivia(Collections.emptyList());
                this.trivias.add(Trivia.createComment(this.tokenBuilder.build()));
                return null;
            }
        } else {
            this.updateTokenPositionAndValue(node);
            this.tokenBuilder.setType(UNDEFINED_TOKEN_TYPE);
        }
        Token token = this.tokenBuilder.setTrivia(this.trivias).build();
        this.trivias.clear();
        AstNode astNode = new AstNode(token);
        astNode.setFromIndex(node.getStartIndex());
        astNode.setToIndex(node.getEndIndex());
        return astNode;
    }

    private void updateTokenPositionAndValue(ParseNode node) {
        TextLocation location = this.input.getLocation(node.getStartIndex());
        if (location == null) {
            this.tokenBuilder.setGeneratedCode(true);
            this.tokenBuilder.setLine(1);
            this.tokenBuilder.setColumn(0);
            this.tokenBuilder.setURI(FAKE_URI);
        } else {
            this.tokenBuilder.setGeneratedCode(false);
            this.tokenBuilder.setLine(location.getLine());
            this.tokenBuilder.setColumn(location.getColumn() - 1);
            this.tokenBuilder.setURI(location.getFileURI() == null ? FAKE_URI : location.getFileURI());
            this.tokenBuilder.notCopyBook();
        }
        String value = this.getValue(node);
        this.tokenBuilder.setValueAndOriginalValue(value);
    }

    private AstNode visitNonTerminal(ParseNode node) {
        MutableParsingRule ruleMatcher = (MutableParsingRule)node.getMatcher();
        ArrayList<AstNode> astNodes = new ArrayList<AstNode>();
        for (ParseNode parseNode : node.getChildren()) {
            AstNode astNode = this.visit(parseNode);
            if (astNode == null) continue;
            if (astNode.hasToBeSkippedFromAst()) {
                astNodes.addAll(astNode.getChildren());
                continue;
            }
            astNodes.add(astNode);
        }
        Token token = null;
        for (AstNode child : astNodes) {
            if (child.getToken() == null) continue;
            token = child.getToken();
            break;
        }
        AstNode astNode = new AstNode(ruleMatcher, ruleMatcher.getName(), token);
        for (AstNode child : astNodes) {
            astNode.addChild(child);
        }
        astNode.setFromIndex(node.getStartIndex());
        astNode.setToIndex(node.getEndIndex());
        return astNode;
    }

    private String getValue(ParseNode node) {
        StringBuilder result = new StringBuilder();
        for (int i = node.getStartIndex(); i < Math.min(node.getEndIndex(), this.input.length()); ++i) {
            result.append(this.input.charAt(i));
        }
        return result.toString();
    }

    static {
        try {
            FAKE_URI = new URI("tests://unittest");
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        UNDEFINED_TOKEN_TYPE = new TokenType(){

            @Override
            public String getName() {
                return "TOKEN";
            }

            @Override
            public String getValue() {
                return this.getName();
            }

            @Override
            public boolean hasToBeSkippedFromAst(AstNode node) {
                return false;
            }
        };
    }
}

