/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.index.shared;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.net.UrlUtils;
import org.conqat.lib.commons.string.StringUtils;

public enum EGitProtocol {
    FILE("file", "//"),
    HTTP("http", "//"),
    HTTPS("https", "//"),
    SSH("ssh", "//git@"),
    GIT("git", "//");

    private final String protocol;
    private final String prefix;

    private EGitProtocol(String protocol, String protocolSuffix) {
        this.protocol = protocol;
        this.prefix = protocol + ":" + protocolSuffix;
    }

    public static Optional<EGitProtocol> fromUri(String uri) {
        try {
            return EGitProtocol.fromUri(UrlUtils.parseUri((String)uri));
        }
        catch (URISyntaxException e) {
            return Optional.empty();
        }
    }

    public static Optional<EGitProtocol> fromUri(URI uri) {
        return Optional.ofNullable((EGitProtocol)EnumUtils.valueOfIgnoreCase(EGitProtocol.class, (String)uri.getScheme()));
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getUrlPrefix() {
        return this.prefix;
    }

    public String stripUrlPrefix(String url) {
        return StringUtils.stripPrefix((String)url, (String)this.getUrlPrefix());
    }
}

