/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.coverage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.conqat.engine.sourcecode.coverage.CoverageProbeBase;
import org.conqat.engine.sourcecode.coverage.DecisionProbeConfiguration;
import org.conqat.engine.sourcecode.coverage.McDcCondition;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class DecisionProbe
extends CoverageProbeBase {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="trueExecutionCount")
    private int trueExecutionCount;
    @JsonProperty(value="falseExecutionCount")
    private int falseExecutionCount;
    @JsonProperty(value="configurations")
    private final List<DecisionProbeConfiguration> configurations = new ArrayList<DecisionProbeConfiguration>();
    @JsonProperty(value="conditions")
    private final List<McDcCondition> conditions = new ArrayList<McDcCondition>();

    @JsonCreator
    public DecisionProbe(@JsonProperty(value="line") int line, @JsonProperty(value="trueExecutionCount") int trueExecutionCount, @JsonProperty(value="falseExecutionCount") int falseExecutionCount) {
        super(line);
        this.trueExecutionCount = trueExecutionCount;
        this.falseExecutionCount = falseExecutionCount;
    }

    public int getFalseExecutionCount() {
        return this.falseExecutionCount;
    }

    public int getTrueExecutionCount() {
        return this.trueExecutionCount;
    }

    public void addConfiguration(DecisionProbeConfiguration configuration) {
        this.configurations.add(configuration);
    }

    public void addCondition(McDcCondition condition) {
        this.conditions.add(condition);
    }

    public UnmodifiableList<McDcCondition> getConditions() {
        return CollectionUtils.asUnmodifiable(this.conditions);
    }

    public UnmodifiableList<DecisionProbeConfiguration> getConfigurations() {
        return CollectionUtils.asUnmodifiable(this.configurations);
    }

    public String toString() {
        StringBuilder result = new StringBuilder("Decision in line " + this.getLine() + "\n");
        result.append(StringUtils.concat(this.configurations, (String)"\n"));
        result.append(StringUtils.concat(this.conditions, (String)"\n"));
        return result.toString();
    }

    @Override
    @JsonIgnore
    public int getCoverableCount() {
        return 2 + this.getConditions().size();
    }

    @Override
    @JsonIgnore
    public int getCoveredCount() {
        int coveredCount = 0;
        if (this.trueExecutionCount > 0) {
            ++coveredCount;
        }
        if (this.falseExecutionCount > 0) {
            ++coveredCount;
        }
        for (McDcCondition condition : this.conditions) {
            if (!condition.isFulfilled()) continue;
            ++coveredCount;
        }
        return coveredCount;
    }

    @Override
    public boolean mergeWith(CoverageProbeBase other) {
        CCSMAssert.isInstanceOf((Object)other, DecisionProbe.class);
        DecisionProbe sourceDecisionProbe = (DecisionProbe)other;
        this.trueExecutionCount += sourceDecisionProbe.trueExecutionCount;
        this.falseExecutionCount += sourceDecisionProbe.falseExecutionCount;
        DecisionProbe.mergeIntoList(this.configurations, sourceDecisionProbe.configurations, DecisionProbeConfiguration::haveSameDescriptionAndDecisionValue, (target, source) -> target.increaseExecutionCount(source.getExecutionCount()));
        DecisionProbe.mergeIntoList(this.conditions, sourceDecisionProbe.conditions, (target, source) -> target.getDescription().equals(source.getDescription()), (target, source) -> target.setFulfilled(target.isFulfilled() || source.isFulfilled()));
        return false;
    }

    private static <T> void mergeIntoList(List<T> targets, List<T> sources, BiFunction<T, T, Boolean> equalsChecker, BiConsumer<T, T> targetSourceMerger) {
        for (Object source : sources) {
            Optional<Object> match = targets.stream().filter(target -> (Boolean)equalsChecker.apply(source, target)).findFirst();
            if (!match.isPresent()) {
                targets.add(source);
                continue;
            }
            targetSourceMerger.accept(match.get(), source);
        }
    }
}

