/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.preprocessor.c;

import com.google.common.base.Preconditions;
import eu.cqse.check.framework.preprocessor.c.CPreprocessor;
import eu.cqse.check.framework.scanner.IToken;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class PreprocessorTokenReplacement
implements Serializable {
    private static final long serialVersionUID = 1L;
    final List<IToken> replacementTokens;
    public final int originalTokensStartIndex;
    public final int originalTokensEndIndex;
    public final transient CPreprocessor.PreprocessorUsageInformation preprocessorUsageInformation;
    public final @Nullable String errorMessage;

    public PreprocessorTokenReplacement(List<IToken> replacementTokens, int originalTokensStartIndex, int originalTokensEndIndex, CPreprocessor.PreprocessorUsageInformation preprocessorUsageInformation) {
        this(replacementTokens, originalTokensStartIndex, originalTokensEndIndex, preprocessorUsageInformation, null);
    }

    public PreprocessorTokenReplacement(List<IToken> replacementTokens, int originalTokensStartIndex, int originalTokensEndIndex, CPreprocessor.PreprocessorUsageInformation preprocessorUsageInformation, @Nullable String errorMessage) {
        this.replacementTokens = replacementTokens;
        this.originalTokensStartIndex = originalTokensStartIndex;
        this.originalTokensEndIndex = originalTokensEndIndex;
        this.preprocessorUsageInformation = preprocessorUsageInformation;
        this.errorMessage = errorMessage;
        CCSMAssert.isTrue((originalTokensStartIndex <= originalTokensEndIndex ? 1 : 0) != 0, (String)"replacement start must be smaller or equal to end");
        CCSMAssert.isTrue((originalTokensStartIndex < originalTokensEndIndex || replacementTokens.isEmpty() ? 1 : 0) != 0, (String)"replacementList must be empty if start equal to end");
    }

    public static PreprocessorTokenReplacement createSingleTokenRemoval(int originalTokenIndex) {
        return new PreprocessorTokenReplacement(Collections.emptyList(), originalTokenIndex, originalTokenIndex + 1, new CPreprocessor.PreprocessorUsageInformation());
    }

    static PreprocessorTokenReplacement createSingleTokenRemovalWithError(String errorMessage, int tokenIndex, CPreprocessor.PreprocessorUsageInformation preprocessorUsageInformation) {
        return new PreprocessorTokenReplacement(Collections.emptyList(), tokenIndex, tokenIndex + 1, preprocessorUsageInformation, errorMessage);
    }

    static PreprocessorTokenReplacement createTokensRemovalWithError(String errorMessage, UnmodifiableList<String> includeHierarchy, int tokenIndex, int endTokenIndex, CPreprocessor.PreprocessorUsageInformation preprocessorUsageInformation) {
        Preconditions.checkArgument((endTokenIndex > tokenIndex ? 1 : 0) != 0);
        return new PreprocessorTokenReplacement(Collections.emptyList(), tokenIndex, endTokenIndex, preprocessorUsageInformation, errorMessage);
    }

    public @Nullable TextRegionLocation buildLocationForReplacedTokens(List<IToken> tokens, String uniformPath) {
        if (this.originalTokensStartIndex == this.originalTokensEndIndex) {
            return null;
        }
        IToken firstReplacedToken = tokens.get(this.originalTokensStartIndex);
        IToken lastReplacedToken = tokens.get(this.originalTokensEndIndex - 1);
        return new TextRegionLocation(uniformPath, firstReplacedToken.getOffset(), lastReplacedToken.getOffset() + lastReplacedToken.getText().length(), firstReplacedToken.getLineNumber(), lastReplacedToken.getLineNumber() + StringUtils.countLines((String)lastReplacedToken.getText()) - 1);
    }

    public boolean replacesOriginalTokenIndex(int originalTokenIndex) {
        return this.originalTokensStartIndex <= originalTokenIndex && this.originalTokensEndIndex > originalTokenIndex;
    }

    public int countReplacedTokens() {
        return this.originalTokensEndIndex - this.originalTokensStartIndex;
    }

    void setTokensOriginAndOffset(IToken originalSourceToken) {
        for (int i = 0; i < this.replacementTokens.size(); ++i) {
            IToken expansionToken = this.replacementTokens.get(i);
            this.replacementTokens.set(i, expansionToken.newToken(expansionToken.getType(), originalSourceToken.getOffset(), originalSourceToken.getLineNumber(), expansionToken.getText(), "##macro##"));
        }
    }

    public UnmodifiableList<IToken> getReplacementTokens() {
        return CollectionUtils.asUnmodifiable(new ArrayList<IToken>(this.replacementTokens));
    }
}

