/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.wia;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.INameResolver;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.framework.ShallowParserBase;
import eu.cqse.check.framework.shallowparser.languages.wia.EWorkItemParserStates;

public class WorkItemShallowParser
extends ShallowParserBase<EWorkItemParserStates> {
    private static final ITokenMatcher KEY_TYPES = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.KEY, ETokenType.STRING_LITERAL});
    public static final EShallowEntityType ATTRIBUTE_TYPE = EShallowEntityType.METHOD;

    private WorkItemShallowParser(ELanguage workItemType) {
        super(EWorkItemParserStates.class, EWorkItemParserStates.INITIAL);
        this.createRootNodeRule(workItemType);
        this.createObjectRules();
        this.createArrayRules();
        this.createAttributeRules();
        this.createLiteralRules();
    }

    private void createRootNodeRule(ELanguage workItemType) {
        this.inState(new EWorkItemParserStates[]{EWorkItemParserStates.INITIAL}).createNode(EShallowEntityType.TYPE, workItemType.name()).parseMultiple(EWorkItemParserStates.IN_WORK_ITEM).endNode();
    }

    private void createObjectRules() {
        this.inState(new EWorkItemParserStates[]{EWorkItemParserStates.IN_ATTRIBUTE, EWorkItemParserStates.IN_ARRAY}).optional(new ITokenMatcher[]{ETokenType.COMMA}).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).markStart().createNode(EShallowEntityType.META, "object").parseMultiple(EWorkItemParserStates.IN_OBJECT).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private void createArrayRules() {
        this.inState(new EWorkItemParserStates[]{EWorkItemParserStates.IN_ATTRIBUTE, EWorkItemParserStates.IN_ARRAY}).optional(new ITokenMatcher[]{ETokenType.COMMA}).sequence(new ITokenMatcher[]{ETokenType.LBRACK}).markStart().createNode(EShallowEntityType.META, "array").parseMultiple(EWorkItemParserStates.IN_ARRAY).sequence(new ITokenMatcher[]{ETokenType.RBRACK}).endNode();
    }

    private void createAttributeRules() {
        this.inState(new EWorkItemParserStates[]{EWorkItemParserStates.IN_WORK_ITEM, EWorkItemParserStates.IN_OBJECT}).optional(new ITokenMatcher[]{ETokenType.COMMA}).markStart().sequence(KEY_TYPES).repeated(new ITokenMatcher[]{ETokenType.DOT, KEY_TYPES}).createNode(ATTRIBUTE_TYPE, "attribute", INameResolver.ofRange(0, -1)).sequence(new ITokenMatcher[]{ETokenType.EQ}).markStart().parseOnce(EWorkItemParserStates.IN_ATTRIBUTE).endNode();
    }

    private void createLiteralRules() {
        RecognizerBase attributeRecognizer = this.inState(new EWorkItemParserStates[]{EWorkItemParserStates.IN_ATTRIBUTE, EWorkItemParserStates.IN_ARRAY}).optional(new ITokenMatcher[]{ETokenType.COMMA}).markStart();
        for (ETokenType literalType : ETokenType.getTokenTypesByClass((ETokenType.ETokenClass)ETokenType.ETokenClass.LITERAL)) {
            attributeRecognizer.sequence(new ITokenMatcher[]{literalType}).createNode(EShallowEntityType.ATTRIBUTE, literalType.name(), INameResolver.firstMatchedTokenText()).endNodeWithContinuation();
        }
    }

    public static WorkItemShallowParser forRequirements() {
        return new WorkItemShallowParser(ELanguage.NL_REQUIREMENTS);
    }

    public static WorkItemShallowParser forTests() {
        return new WorkItemShallowParser(ELanguage.NL_TESTS);
    }

    public static WorkItemShallowParser forIssues() {
        return new WorkItemShallowParser(ELanguage.NL_ISSUES);
    }
}

