/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.env.DatabaseRoot;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.LoggableIteratorUnsafe;
import jetbrains.exodus.env.MetaTreeImpl;
import jetbrains.exodus.env.MetaTreePrototype;
import jetbrains.exodus.io.Block;
import jetbrains.exodus.log.BlockDataIterator;
import jetbrains.exodus.log.BlockSet;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.LogTip;
import jetbrains.exodus.log.NullLoggable;
import jetbrains.exodus.log.RandomAccessLoggable;
import jetbrains.exodus.tree.btree.BTree;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a6\u0010\u0000\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0002\u001a#\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f*\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u000f\u00a2\u0006\u0002\u0010\u0010\u001a#\u0010\u0011\u001a\u0002H\f\"\u0004\b\u0000\u0010\f*\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u000f\u00a2\u0006\u0002\u0010\u0010\u001a(\u0010\u0012\u001a\u00020\u0013*\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f\u001a\f\u0010\u0000\u001a\u00020\u0018*\u00020\rH\u0000\u001a\"\u0010\u0000\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0001*\u00020\u00052\u0006\u0010\b\u001a\u00020\u0003H\u0002\u001a\f\u0010\u0019\u001a\u00020\u0018*\u00020\rH\u0002\u00a8\u0006\u001a"}, d2={"tryUpdate", "Lkotlin/Pair;", "Ljetbrains/exodus/env/DatabaseRoot;", "Ljetbrains/exodus/log/LogTip;", "log", "Ljetbrains/exodus/log/Log;", "lastBlock", "Ljetbrains/exodus/io/Block;", "tip", "blockSet", "Ljetbrains/exodus/log/BlockSet$Mutable;", "executeInCommitLock", "T", "Ljetbrains/exodus/env/EnvironmentImpl;", "action", "Lkotlin/Function0;", "(Ljetbrains/exodus/env/EnvironmentImpl;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "executeInMetaWriteLock", "reopenMetaTree", "", "proto", "Ljetbrains/exodus/env/MetaTreePrototype;", "rollbackTo", "confirm", "", "tryUpdateUnsafe", "xodus-environment"})
public final class UnsafeKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T executeInCommitLock(@NotNull EnvironmentImpl $this$executeInCommitLock, @NotNull Function0<? extends T> action) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$executeInCommitLock, (String)"<this>");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Object object2 = $this$executeInCommitLock.commitLock;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"commitLock");
        synchronized (object2) {
            boolean bl = false;
            object = action.invoke();
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T executeInMetaWriteLock(@NotNull EnvironmentImpl $this$executeInMetaWriteLock, @NotNull Function0<? extends T> action) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$executeInMetaWriteLock, (String)"<this>");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Lock lock = $this$executeInMetaWriteLock.metaWriteLock;
        Intrinsics.checkNotNullExpressionValue((Object)lock, (String)"metaWriteLock");
        lock = lock;
        lock.lock();
        try {
            boolean bl = false;
            object = action.invoke();
        }
        finally {
            lock.unlock();
        }
        return (T)object;
    }

    public static final void reopenMetaTree(@NotNull EnvironmentImpl $this$reopenMetaTree, @NotNull MetaTreePrototype proto, @NotNull LogTip rollbackTo, @NotNull Function0<? extends LogTip> confirm) {
        Intrinsics.checkNotNullParameter((Object)$this$reopenMetaTree, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)rollbackTo, (String)"rollbackTo");
        Intrinsics.checkNotNullParameter(confirm, (String)"confirm");
        Ref.ObjectRef logTip = new Ref.ObjectRef();
        try {
            UnsafeKt.executeInMetaWriteLock($this$reopenMetaTree, (Function0)new Function0<Unit>((Ref.ObjectRef<LogTip>)logTip, confirm, $this$reopenMetaTree, proto){
                final /* synthetic */ Ref.ObjectRef<LogTip> $logTip;
                final /* synthetic */ Function0<LogTip> $confirm;
                final /* synthetic */ EnvironmentImpl $this_reopenMetaTree;
                final /* synthetic */ MetaTreePrototype $proto;
                {
                    this.$logTip = $logTip;
                    this.$confirm = $confirm;
                    this.$this_reopenMetaTree = $receiver;
                    this.$proto = $proto;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void it;
                    Object object = this.$confirm.invoke();
                    EnvironmentImpl environmentImpl = this.$this_reopenMetaTree;
                    MetaTreePrototype metaTreePrototype = this.$proto;
                    LogTip logTip = (LogTip)object;
                    Ref.ObjectRef<LogTip> objectRef = this.$logTip;
                    boolean bl = false;
                    environmentImpl.setMetaTreeInternal(MetaTreeImpl.create(environmentImpl, (LogTip)it, metaTreePrototype));
                    objectRef.element = object;
                }
            });
        }
        catch (Throwable t) {
            LogTip logTip2 = (LogTip)logTip.element;
            if (logTip2 != null) {
                LogTip it = logTip2;
                boolean bl = false;
                $this$reopenMetaTree.getLog().setHighAddress(it, rollbackTo.highAddress);
            }
            RuntimeException runtimeException = ExodusException.toExodusException((Throwable)t, (String)"Failed to reopen MetaTree");
            Intrinsics.checkNotNullExpressionValue((Object)runtimeException, (String)"toExodusException(t, \"Failed to reopen MetaTree\")");
            throw (Throwable)runtimeException;
        }
    }

    public static final boolean tryUpdate(@NotNull EnvironmentImpl $this$tryUpdate) {
        Intrinsics.checkNotNullParameter((Object)$this$tryUpdate, (String)"<this>");
        return (Boolean)UnsafeKt.executeInCommitLock($this$tryUpdate, (Function0)new Function0<Boolean>($this$tryUpdate){
            final /* synthetic */ EnvironmentImpl $this_tryUpdate;
            {
                this.$this_tryUpdate = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return UnsafeKt.access$tryUpdateUnsafe(this.$this_tryUpdate);
            }
        });
    }

    private static final boolean tryUpdateUnsafe(EnvironmentImpl $this$tryUpdateUnsafe) {
        LogTip tip = $this$tryUpdateUnsafe.getLog().getTip();
        Log log = $this$tryUpdateUnsafe.getLog();
        Intrinsics.checkNotNullExpressionValue((Object)log, (String)"log");
        Pair<DatabaseRoot, LogTip> pair = UnsafeKt.tryUpdate(log, tip);
        if (pair != null) {
            Pair<DatabaseRoot, LogTip> it = pair;
            boolean bl = false;
            LogTip updatedTip = (LogTip)it.getSecond();
            return (Boolean)UnsafeKt.executeInMetaWriteLock($this$tryUpdateUnsafe, (Function0)new Function0<Boolean>($this$tryUpdateUnsafe, tip, updatedTip, it){
                final /* synthetic */ EnvironmentImpl $this_tryUpdateUnsafe;
                final /* synthetic */ LogTip $tip;
                final /* synthetic */ LogTip $updatedTip;
                final /* synthetic */ Pair<DatabaseRoot, LogTip> $it;
                {
                    this.$this_tryUpdateUnsafe = $receiver;
                    this.$tip = $tip;
                    this.$updatedTip = $updatedTip;
                    this.$it = $it;
                    super(0);
                }

                @NotNull
                public final Boolean invoke() {
                    boolean bl;
                    try {
                        boolean bl2;
                        Boolean bl3;
                        this.$this_tryUpdateUnsafe.getLog().compareAndSetTip(this.$tip, this.$updatedTip);
                        long root = ((DatabaseRoot)this.$it.getFirst()).getRootAddress();
                        BTree bTree = this.$this_tryUpdateUnsafe.loadMetaTree(root, this.$updatedTip);
                        if (bTree == null) {
                            bl3 = null;
                        } else {
                            MetaTreeImpl metaTreeImpl;
                            BTree bTree2 = bTree;
                            EnvironmentImpl environmentImpl = this.$this_tryUpdateUnsafe;
                            LogTip logTip = this.$updatedTip;
                            BTree metaTree = bTree2;
                            boolean bl4 = false;
                            MetaTreeImpl metaTreeImpl2 = metaTreeImpl = new MetaTreeImpl(metaTree, root, logTip);
                            EnvironmentImpl environmentImpl2 = environmentImpl;
                            boolean bl5 = false;
                            MetaTreeImpl.cloneTree(metaTree);
                            environmentImpl2.setMetaTreeInternal(metaTreeImpl);
                            bl3 = true;
                        }
                        Boolean bl6 = bl3;
                        if (bl6 == null) {
                            EnvironmentImpl $this$invoke_u24lambda_u2d2 = this.$this_tryUpdateUnsafe;
                            boolean bl7 = false;
                            $this$invoke_u24lambda_u2d2.throwableOnCommit = new Throwable("Cannot load updated meta tree");
                            bl2 = false;
                        } else {
                            bl2 = bl6;
                        }
                        bl = bl2;
                    }
                    catch (Throwable t) {
                        this.$this_tryUpdateUnsafe.throwableOnCommit = new Throwable("Cannot read updated meta tree", t);
                        bl = true;
                    }
                    return bl;
                }
            });
        }
        return false;
    }

    private static final Pair<DatabaseRoot, LogTip> tryUpdate(Log $this$tryUpdate, LogTip tip) {
        Block block;
        BlockSet.Mutable blockSet = tip.getBlockSetCopy();
        Iterable iterable = $this$tryUpdate.getConfig().getReader().getBlocks($this$tryUpdate.getFileAddress(tip.highAddress));
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"config.reader.getBlocks(\u2026Address(tip.highAddress))");
        Iterable addedBlocks = iterable;
        Iterator itr = addedBlocks.iterator();
        if (!itr.hasNext()) {
            return null;
        }
        Block lastBlock = null;
        do {
            block = (Block)itr.next();
            long l = block.getAddress();
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"block");
            blockSet.add(l, block);
        } while (itr.hasNext());
        lastBlock = block;
        Intrinsics.checkNotNullExpressionValue((Object)blockSet, (String)"blockSet");
        return UnsafeKt.tryUpdate($this$tryUpdate, lastBlock, tip, blockSet);
    }

    /*
     * WARNING - void declaration
     */
    private static final Pair<DatabaseRoot, LogTip> tryUpdate(Log log, Block lastBlock, LogTip tip, BlockSet.Mutable blockSet) {
        void $this$tryUpdate_u24lambda_u2d4;
        long lastBlockAddress = lastBlock.getAddress();
        long highAddress = lastBlockAddress + lastBlock.length();
        long startAddress = Math.max(tip.approvedHighAddress, lastBlockAddress);
        if (startAddress > lastBlockAddress + log.getFileLengthBound()) {
            throw new IllegalStateException("Log truncated abnormally, aborting");
        }
        BlockDataIterator dataIterator = new BlockDataIterator(log, tip, lastBlock, startAddress);
        LoggableIteratorUnsafe loggables = new LoggableIteratorUnsafe(log, dataIterator);
        byte rootType = 1;
        DatabaseRoot lastRoot = null;
        Ref.LongRef approvedHighAddress = new Ref.LongRef();
        approvedHighAddress.element = startAddress;
        try {
            RandomAccessLoggable loggable;
            long loggableEnd;
            while (loggables.hasNext() && (loggableEnd = (loggable = loggables.next()).getAddress() + (long)loggable.length()) <= highAddress) {
                if (loggable.getType() == rootType) {
                    lastRoot = new DatabaseRoot(loggable, loggables.getIterator$xodus_environment());
                } else if (!NullLoggable.isNullLoggable(loggable)) {
                    long expectedDataLength = loggable.getDataLength();
                    if (loggables.getIterator$xodus_environment().skip(expectedDataLength) < expectedDataLength) break;
                }
                if (loggableEnd == dataIterator.getAddress()) {
                    approvedHighAddress.element = loggableEnd;
                    if (loggableEnd != highAddress) continue;
                }
                break;
            }
        }
        catch (ExodusException e) {
            Log.Companion.getLogger().info((Throwable)e, (Function0)new Function0<Object>(approvedHighAddress){
                final /* synthetic */ Ref.LongRef $approvedHighAddress;
                {
                    this.$approvedHighAddress = $approvedHighAddress;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Exception on Log recovery by tryUpdate() in " + Thread.currentThread().getName() + ". Approved high address = " + this.$approvedHighAddress.element;
                }
            });
        }
        if (lastRoot == null) {
            return null;
        }
        BlockDataIterator e = dataIterator;
        DatabaseRoot databaseRoot = lastRoot;
        boolean bl = false;
        return TuplesKt.to(databaseRoot, (Object)new LogTip($this$tryUpdate_u24lambda_u2d4.getLastPage(), $this$tryUpdate_u24lambda_u2d4.getLastPageAddress(), $this$tryUpdate_u24lambda_u2d4.getLastPageCount(), highAddress, approvedHighAddress.element, blockSet.endWrite()));
    }

    public static final /* synthetic */ boolean access$tryUpdateUnsafe(EnvironmentImpl $receiver) {
        return UnsafeKt.tryUpdateUnsafe($receiver);
    }
}

