/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.engine.persistence.index.IStringKeyIndex;
import org.conqat.engine.persistence.index.IUtilityIndex;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.StoreWithAbbreviationSupport;
import org.conqat.engine.persistence.store.util.ExceptionHandlingKeyValueCallbackBase;
import org.conqat.engine.persistence.store.util.StorageStringAbbreviator;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;

public final class ValueIndex<T>
extends IndexBase
implements IStringKeyIndex<T>,
IUtilityIndex {
    private static final int KEYS_PER_THREAD = Integer.getInteger("com.teamscale.multithreaded_db_serialization.keys_per_thread", 50);
    private static final int THREAD_POOL_SIZE = Runtime.getRuntime().availableProcessors();
    private static final ThreadPoolExecutor THREAD_POOL = new ThreadPoolExecutor(THREAD_POOL_SIZE, THREAD_POOL_SIZE, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
    private final ISerializer<T, byte[]> serializer;

    private ValueIndex(IStore store, ISerializer<T, byte[]> serializer) {
        super(store);
        this.serializer = Objects.requireNonNull(serializer, "serializer");
    }

    public static <T> ValueIndex<T> of(IStore store, ISerializer<T, byte[]> serializer) {
        return new ValueIndex<T>(store, serializer);
    }

    public static ValueIndex<String> forString(IStore store) {
        return ValueIndex.of(store, ISerializer.forString());
    }

    public static ValueIndex<Integer> forInteger(IStore store) {
        return ValueIndex.of(store, ISerializer.forInteger());
    }

    public static ValueIndex<Long> forLong(IStore store) {
        return ValueIndex.of(store, ISerializer.forLong());
    }

    public static <T extends Serializable> ValueIndex<T> forSerializable(IStore store) {
        return ValueIndex.of(store, ISerializer.forSerializable());
    }

    public static ValueIndex<List<String>> forStringListWithAbbreviation(IStore store) {
        if (!(store instanceof StoreWithAbbreviationSupport)) {
            throw new IllegalArgumentException("Provided store does not have string abbreviation support");
        }
        StoreWithAbbreviationSupport abbreviatedStore = (StoreWithAbbreviationSupport)store;
        StorageStringAbbreviator abbreviator = abbreviatedStore.getStringAbbreviator();
        return ValueIndex.forStringListWithAbbreviation(store, abbreviator);
    }

    public static @NonNull ValueIndex<List<String>> forStringListWithAbbreviation(IStore store, StorageStringAbbreviator abbreviator) {
        return new ValueIndex<List<String>>(store, ISerializer.mapping(ISerializer.of(abbreviator::abbreviate, abbreviator::unabbreviate), ISerializer.of(ByteArrayUtils::serializeIntegerList, ByteArrayUtils::deserializeIntegerList)));
    }

    private static void handleExceptionFromFuture(Exception e) throws StorageException {
        Throwable throwable = e.getCause();
        if (throwable instanceof StorageException) {
            StorageException storageException = (StorageException)((Object)throwable);
            throw storageException;
        }
        throw new StorageException(e);
    }

    private byte[] valueToByteArray(T value) throws StorageException {
        return this.serializer.serialize(value);
    }

    private T byteArrayToValue(byte[] bytes) throws StorageException {
        return this.serializer.deserialize(bytes);
    }

    @Override
    public T getValue(@NonNull String key) throws StorageException {
        return this.getValue(key, false);
    }

    @Override
    public T getValue(@NonNull String key, boolean forceExistence) throws StorageException {
        byte[] bytes = this.store.getWithString(key);
        if (bytes == null) {
            if (forceExistence) {
                throw new StorageException("No element stored found for key " + key);
            }
            return null;
        }
        return this.byteArrayToValue(bytes);
    }

    @Override
    public List<T> getValues(List<@NonNull String> keys) throws StorageException {
        return this.getValues(keys, false);
    }

    @Override
    public List<T> getValues(List<@NonNull String> keys, boolean forceExistence) throws StorageException {
        List<byte[]> values = this.store.getWithStrings(keys);
        List partitionedKeys = Lists.partition(keys, (int)KEYS_PER_THREAD);
        List partitionedValues = Lists.partition(values, (int)KEYS_PER_THREAD);
        ArrayList<Future<List>> futures = new ArrayList<Future<List>>();
        int partitionNumber = 0;
        while (partitionNumber < partitionedKeys.size()) {
            int finalPartitionNumber = partitionNumber++;
            futures.add(THREAD_POOL.submit(() -> this.convertBytesToValues((List)partitionedKeys.get(finalPartitionNumber), (List)partitionedValues.get(finalPartitionNumber), forceExistence)));
        }
        ArrayList result = new ArrayList();
        for (Future future : futures) {
            try {
                result.addAll((Collection)future.get());
            }
            catch (InterruptedException | ExecutionException e) {
                ValueIndex.handleExceptionFromFuture(e);
            }
        }
        return result;
    }

    private List<T> convertBytesToValues(List<String> keys, List<byte[]> values, boolean forceExistence) throws StorageException {
        ArrayList<T> converted = new ArrayList<T>();
        for (int i = 0; i < keys.size(); ++i) {
            byte[] value = values.get(i);
            if (value != null) {
                converted.add(this.byteArrayToValue(value));
                continue;
            }
            if (forceExistence) {
                throw new StorageException("No value found for " + keys.get(i));
            }
            converted.add(null);
        }
        return converted;
    }

    @Override
    public void setValue(@NonNull String key, @NonNull T value) throws StorageException {
        if (value == null) {
            throw new AssertionError((Object)("Trying to set null for key " + key));
        }
        byte[] bytes = this.valueToByteArray(value);
        if (bytes == null) {
            throw new AssertionError((Object)("Value " + String.valueOf(value) + " was converted to null."));
        }
        this.store.putWithString(key, bytes);
    }

    @Override
    public void setOrMergeValue(@NonNull String key, @NonNull T value, BinaryOperator<T> mergeFunction) throws StorageException {
        T oldValue = this.getValue(key);
        if (oldValue != null) {
            value = mergeFunction.apply(oldValue, value);
        }
        this.setValue(key, value);
    }

    @Override
    public void setOrMergeValues(PairList<@NonNull String, T> keysAndValues, BinaryOperator<T> mergeFunction) throws StorageException {
        List<T> existingValues = this.getValues(keysAndValues.extractFirstList());
        HashMap<String, Object> mergedValues = new HashMap<String, Object>(keysAndValues.size());
        for (int i = 0; i < keysAndValues.size(); ++i) {
            String key = (String)keysAndValues.getFirst(i);
            Object oldValue = existingValues.get(i);
            if (mergedValues.containsKey(key)) {
                oldValue = mergedValues.get(key);
            }
            Object value = keysAndValues.getSecond(i);
            if (oldValue != null) {
                value = mergeFunction.apply(oldValue, value);
            }
            mergedValues.put(key, value);
        }
        this.setValues(new PairList(mergedValues));
    }

    @Override
    public void removeValue(@NonNull String key) throws StorageException {
        this.store.removeWithString(key);
    }

    @Override
    public void setValues(PairList<@NonNull String, T> values) throws StorageException {
        List partitionedKeys = Lists.partition((List)values.extractFirstList(), (int)KEYS_PER_THREAD);
        List partitionedValues = Lists.partition((List)values.extractSecondList(), (int)KEYS_PER_THREAD);
        ArrayList<Future<PairList>> futures = new ArrayList<Future<PairList>>();
        int partitionNumber = 0;
        while (partitionNumber < partitionedKeys.size()) {
            int finalPartitionNumber = partitionNumber++;
            Callable<PairList> callable = () -> this.convertValuesToBytes((List)partitionedKeys.get(finalPartitionNumber), (List)partitionedValues.get(finalPartitionNumber));
            futures.add(THREAD_POOL.submit(callable));
        }
        PairList byteValues = new PairList();
        for (Future future : futures) {
            try {
                byteValues.addAll((PairList)future.get());
            }
            catch (InterruptedException | ExecutionException e) {
                ValueIndex.handleExceptionFromFuture(e);
            }
        }
        this.store.putWithStrings((PairList<String, byte[]>)byteValues);
    }

    private PairList<String, byte[]> convertValuesToBytes(List<@NonNull String> keyPartition, List<T> valuePartition) throws StorageException {
        PairList byteValues = new PairList();
        for (int i = 0; i < keyPartition.size(); ++i) {
            String key = keyPartition.get(i);
            byte[] value = this.valueToByteArray(valuePartition.get(i));
            CCSMAssert.isNotNull((Object)value, () -> "Trying to set null for key %s".formatted(key));
            byteValues.add((Object)key, (Object)value);
        }
        return byteValues;
    }

    @Override
    public void removeValues(Collection<@NonNull String> keys) throws StorageException {
        List<String> list;
        if (keys instanceof List) {
            List l = (List)keys;
            list = l;
        } else {
            list = new ArrayList<String>(keys);
        }
        this.store.removeWithStrings(list);
    }

    @Override
    public List<String> getAllKeys() throws StorageException {
        return StorageUtils.listStringKeys(this.store);
    }

    @Override
    public List<String> getKeysStartingWith(@NonNull String prefix) throws StorageException {
        final ArrayList<String> result = new ArrayList<String>();
        ExceptionHandlingKeyValueCallbackBase callbackWrapper = new ExceptionHandlingKeyValueCallbackBase(this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void callbackWithException(byte[] key, byte[] value) {
                String stringKey = StringUtils.bytesToString((byte[])key);
                List list = result;
                synchronized (list) {
                    result.add(stringKey);
                }
            }
        };
        byte[] bytePrefix = StringUtils.stringToBytes((String)prefix);
        this.store.scanKeys(bytePrefix, (IKeyValueCallback)callbackWrapper);
        callbackWrapper.throwCaughtException();
        return result;
    }

    @Override
    public PairList<String, T> getAllEntries() throws StorageException {
        if (this.store.hasAbbreviatedKeys()) {
            PairList<byte[], byte[]> entries = this.store.getEntriesStartingWith(ByteArrayUtils.EMPTY_ARRAY);
            List<Integer> abbreviatedKeys = entries.getFirstList().stream().map(ByteArrayUtils::byteArrayToInt).collect(Collectors.toList());
            List<String> expandedKeys = this.store.getAbbreviator().unabbreviate(abbreviatedKeys);
            PairList result = new PairList();
            for (int i = 0; i < entries.size(); ++i) {
                result.add((Object)expandedKeys.get(i), this.byteArrayToValue((byte[])entries.getSecond(i)));
            }
            return result;
        }
        return this.getEntriesStartingWith("");
    }

    @Override
    public PairList<String, T> getEntriesStartingWith(@NonNull String prefix) throws StorageException {
        return this.getEntriesStartingWith(Collections.singletonList(prefix));
    }

    @Override
    public PairList<String, T> getEntriesStartingWith(List<@NonNull String> prefixes) throws StorageException {
        final PairList result = new PairList();
        ExceptionHandlingKeyValueCallbackBase callbackWrapper = new ExceptionHandlingKeyValueCallbackBase(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void callbackWithException(byte[] key, byte[] value) throws StorageException {
                String stringKey = StringUtils.bytesToString((byte[])key);
                PairList pairList = result;
                synchronized (pairList) {
                    result.add((Object)stringKey, ValueIndex.this.byteArrayToValue(value));
                }
            }
        };
        ArrayList<byte[]> bytePrefixes = new ArrayList<byte[]>(prefixes.size());
        for (String prefix : prefixes) {
            bytePrefixes.add(StringUtils.stringToBytes((String)prefix));
        }
        this.store.scan(bytePrefixes, (IKeyValueCallback)callbackWrapper);
        callbackWrapper.throwCaughtException();
        return result;
    }

    @Override
    public Set<String> getContainedKeys(List<@NonNull String> keys) throws StorageException {
        HashSet<String> existingKeys = new HashSet<String>();
        List<byte[]> results = this.store.get(CollectionUtils.map(keys, StringUtils::stringToBytes));
        for (int i = 0; i < results.size(); ++i) {
            if (results.get(i) == null) continue;
            existingKeys.add(keys.get(i));
        }
        return existingKeys;
    }

    public void removeEntriesStartingWith(List<@NonNull String> prefixes) throws StorageException {
        for (String prefix : prefixes) {
            this.store.removeByPrefix(StringUtils.stringToBytes((String)prefix));
        }
    }

    public void removeAllEntries() throws StorageException {
        StorageUtils.clearStore(this.store);
    }

    @Override
    public IStore getWrappedStore() {
        return this.store.getWrappedStore();
    }
}

