/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.keyed.query.trend;

import com.google.common.collect.Sets;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.List;
import java.util.Set;
import org.conqat.engine.persistence.index.keyed.TimedShallowObjectState;
import org.conqat.engine.persistence.index.keyed.query.trend.ITrendCollector;
import org.conqat.engine.persistence.index.keyed.query.trend.SpecItemTrendItem;

public class SpecItemTrendCollector
implements ITrendCollector<SpecItemTrendItem> {
    private final String testReferencesKey;
    private final String codeReferencesKey;
    private Set<TeamscaleIssueId> selectedItems;
    private boolean[] selected;
    private final ReferenceCounter testReferences = new ReferenceCounter();
    private final ReferenceCounter productionReferences = new ReferenceCounter();

    public SpecItemTrendCollector(String testReferencesKey, String codeReferencesKey) {
        this.testReferencesKey = testReferencesKey;
        this.codeReferencesKey = codeReferencesKey;
    }

    @Override
    public void init(int size) {
        this.selectedItems = Sets.newHashSetWithExpectedSize((int)size);
        this.selected = new boolean[size];
        this.testReferences.init(size);
        this.productionReferences.init(size);
    }

    @Override
    public List<String> getRequiredAttributes() {
        return List.of(this.testReferencesKey, this.codeReferencesKey);
    }

    @Override
    public void setRequiredAttributesStartIndex(int index) {
        this.testReferences.setAttributeIndex(index + this.getRequiredAttributes().indexOf(this.testReferencesKey));
        this.productionReferences.setAttributeIndex(index + this.getRequiredAttributes().indexOf(this.codeReferencesKey));
    }

    @Override
    public void update(TimedShallowObjectState timedShallowObjectState, int itemIndex, boolean newSelected) {
        if (newSelected != this.selected[itemIndex]) {
            TeamscaleIssueId issueId = TeamscaleIssueId.fromInternalId((String)timedShallowObjectState.getId());
            if (newSelected) {
                this.selectedItems.add(issueId);
            } else {
                this.selectedItems.remove(issueId);
            }
            this.selected[itemIndex] = newSelected;
        }
        this.testReferences.update(timedShallowObjectState, itemIndex, newSelected);
        this.productionReferences.update(timedShallowObjectState, itemIndex, newSelected);
    }

    @Override
    public SpecItemTrendItem getTrendEntry() {
        return new SpecItemTrendItem(this.selectedItems, this.testReferences.referencesSum, this.testReferences.itemCount, this.productionReferences.referencesSum, this.productionReferences.itemCount);
    }

    private static class ReferenceCounter {
        private int attributeIndex;
        private int[] references;
        private int referencesSum;
        private int itemCount;

        private ReferenceCounter() {
        }

        private void init(int itemCount) {
            this.references = new int[itemCount];
        }

        private void setAttributeIndex(int attributeIndex) {
            this.attributeIndex = attributeIndex;
        }

        private void update(TimedShallowObjectState timedShallowObjectState, int itemIndex, boolean newSelected) {
            int references = ReferenceCounter.getReferences(timedShallowObjectState, newSelected, this.attributeIndex);
            int previousReferences = this.references[itemIndex];
            this.referencesSum += references - previousReferences;
            this.references[itemIndex] = references;
            int previouslyReferencedItems = previousReferences > 0 ? 1 : 0;
            int referencedItems = references > 0 ? 1 : 0;
            this.itemCount += referencedItems - previouslyReferencedItems;
        }

        private static int getReferences(TimedShallowObjectState timedShallowObjectState, boolean newSelected, int attributeIndex) {
            if (newSelected) {
                String frozenValue = timedShallowObjectState.getFrozenValue(attributeIndex);
                if (frozenValue != null) {
                    return Integer.parseInt(frozenValue);
                }
                return 0;
            }
            return 0;
        }
    }
}

