/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.readcache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.StreamSupport;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.DelegatingStorageSystemBase;
import org.conqat.engine.persistence.store.readcache.ICache;
import org.conqat.engine.persistence.store.readcache.ReadCachingStore;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;

public class ReadCachingStorageSystem
extends DelegatingStorageSystemBase {
    private final Cache<CacheKey, ICache.CacheValue<byte[]>> cache;
    private final AtomicInteger prefixSupplier = new AtomicInteger();
    private final Map<String, ReadCachingStore> openStores = new HashMap<String, ReadCachingStore>();

    public ReadCachingStorageSystem(IStorageSystem delegateStorageSystem, long maximumCacheSize) {
        super(delegateStorageSystem);
        CCSMAssert.isTrue((maximumCacheSize > 0L ? 1 : 0) != 0, () -> String.format("Expected \"%s\" (%d) to be positive", "maximumCacheSize", maximumCacheSize));
        this.cache = ReadCachingStorageSystem.buildCache(maximumCacheSize);
    }

    private static Cache<CacheKey, ICache.CacheValue<byte[]>> buildCache(long maximumCacheSize) {
        Caffeine rootBuilder = Caffeine.newBuilder().softValues();
        if (maximumCacheSize != Long.MAX_VALUE) {
            rootBuilder = rootBuilder.maximumWeight(maximumCacheSize).weigher((key, value) -> key.key.length + Optional.ofNullable((byte[])value.value()).map(v -> ((byte[])v).length).orElse(0));
        }
        return rootBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStore openStore(String name) throws StorageException {
        Map<String, ReadCachingStore> map = this.openStores;
        synchronized (map) {
            ReadCachingStore store = this.openStores.get(name);
            if (store == null) {
                store = new ReadCachingStore(super.openStore(name), this.createNewStoreSpecificCache());
                this.openStores.put(name, store);
            }
            return store;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStore(String storeName) throws StorageException {
        ReadCachingStore removed;
        Map<String, ReadCachingStore> map = this.openStores;
        synchronized (map) {
            removed = this.openStores.remove(storeName);
        }
        if (removed != null) {
            removed.invalidateFullCache();
        }
        super.removeStore(storeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHitAndMissStatistics() {
        Map<String, ReadCachingStore> map = this.openStores;
        synchronized (map) {
            StringBuilder builder = new StringBuilder();
            this.openStores.forEach((storeName, store) -> builder.append((String)storeName).append(": ").append(store.getHitAndMissStatistics()).append("\n"));
            return builder.toString();
        }
    }

    private ICache<byte[], byte[]> createNewStoreSpecificCache() {
        final int prefix = this.prefixSupplier.getAndIncrement();
        return new ICache<byte[], byte[]>(){

            private @NonNull CacheKey getCombinedKey(byte[] key) {
                return new CacheKey(prefix, key);
            }

            @Override
            public @Nullable ICache.CacheValue<byte[]> get(byte @NonNull [] key) {
                return (ICache.CacheValue)ReadCachingStorageSystem.this.cache.getIfPresent((Object)this.getCombinedKey(key));
            }

            @Override
            public void put(byte @NonNull [] key, byte @Nullable [] value) {
                ReadCachingStorageSystem.this.cache.put((Object)this.getCombinedKey((byte[])key.clone()), new ICache.CacheValue<byte[]>(value));
            }

            @Override
            public void remove(byte @NonNull [] key) {
                ReadCachingStorageSystem.this.cache.invalidate((Object)this.getCombinedKey(key));
            }

            @Override
            public void remove(@NonNull Iterable<byte[]> keys) {
                ReadCachingStorageSystem.this.cache.invalidateAll(StreamSupport.stream(keys.spliterator(), false).map(this::getCombinedKey)::iterator);
            }

            @Override
            public void removeAll() {
                ReadCachingStorageSystem.this.cache.asMap().keySet().removeIf(cacheKey -> cacheKey.prefix == prefix);
            }
        };
    }

    private record CacheKey(int prefix, byte[] key) {
        private CacheKey {
            CCSMAssert.isNotNull((Object)key, () -> String.format("Expected \"%s\" to be not null", "key"));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof CacheKey)) return false;
            CacheKey o = (CacheKey)obj;
            if (this.prefix != o.prefix) return false;
            if (!Arrays.equals(this.key, o.key)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = Integer.hashCode(this.prefix);
            result = 31 * result + Arrays.hashCode(this.key);
            return result;
        }

        @Override
        public String toString() {
            return this.prefix + ":" + StringUtils.encodeAsHex((byte[])this.key);
        }
    }
}

