/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.capability.IStoreCapability;
import org.conqat.engine.persistence.store.util.ExceptionHandlingKeyValueCallbackBase;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.test.ThreadSafe;

public abstract class AbstractValueTransformingStore
implements IStore {
    private final IStore store;

    protected AbstractValueTransformingStore(IStore store) {
        this.store = store;
    }

    @Override
    public byte[] get(byte @NonNull [] key) throws StorageException {
        return this.reverseTransformation(this.store.get(key));
    }

    @Override
    public List<byte[]> get(List<byte @NonNull []> keys) throws StorageException {
        return this.reverseTransformationForValues(this.store.get(keys));
    }

    @Override
    public void put(byte @NonNull [] key, byte @NonNull [] value) throws StorageException {
        this.store.put(key, this.applyTransformation(value));
    }

    @Override
    public void put(PairList<byte @NonNull [], byte @NonNull []> keysValues) throws StorageException {
        this.store.put(this.applyTransformationForValues(keysValues));
    }

    @Override
    public void remove(byte @NonNull [] key) throws StorageException {
        this.store.remove(key);
    }

    @Override
    public void remove(List<byte @NonNull []> keys) throws StorageException {
        this.store.remove(keys);
    }

    @Override
    public void removeByPrefix(byte @NonNull [] prefix) throws StorageException {
        this.store.removeByPrefix(prefix);
    }

    @Override
    public void scan(byte @NonNull [] beginKey, byte @Nullable [] endKey, IKeyValueCallback callback) throws StorageException {
        ValueTransformingCallback transformingCallback = new ValueTransformingCallback(callback, (FunctionWithException<byte[], byte[], StorageException>)((FunctionWithException)this::reverseTransformation));
        this.store.scan(beginKey, endKey, transformingCallback);
        transformingCallback.throwCaughtException();
    }

    @Override
    public void scan(byte @NonNull [] prefix, IKeyValueCallback callback) throws StorageException {
        ValueTransformingCallback transformingCallback = new ValueTransformingCallback(callback, (FunctionWithException<byte[], byte[], StorageException>)((FunctionWithException)this::reverseTransformation));
        this.store.scan(prefix, (IKeyValueCallback)transformingCallback);
        transformingCallback.throwCaughtException();
    }

    @Override
    public void scan(List<byte @NonNull []> prefixes, List<? extends IKeyValueCallback> callbacks) throws StorageException {
        List transformingCallbacks = CollectionUtils.map(callbacks, callback -> new ValueTransformingCallback((IKeyValueCallback)callback, (FunctionWithException<byte[], byte[], StorageException>)((FunctionWithException)this::reverseTransformation)));
        this.store.scan(prefixes, transformingCallbacks);
        for (ValueTransformingCallback transformingCallback : transformingCallbacks) {
            transformingCallback.throwCaughtException();
        }
    }

    @Override
    public void scanKeys(byte @Nullable [] beginKey, byte @Nullable [] endKey, IKeyValueCallback callback) throws StorageException {
        ValueTransformingCallback nullValueCallback = new ValueTransformingCallback(callback, (FunctionWithException<byte[], byte[], StorageException>)((FunctionWithException)value -> null));
        this.store.scanKeys(beginKey, endKey, nullValueCallback);
        nullValueCallback.throwCaughtException();
    }

    @Override
    public void scanKeys(byte @NonNull [] prefix, IKeyValueCallback callback) throws StorageException {
        ValueTransformingCallback nullValueCallback = new ValueTransformingCallback(callback, (FunctionWithException<byte[], byte[], StorageException>)((FunctionWithException)value -> null));
        this.store.scanKeys(prefix, (IKeyValueCallback)nullValueCallback);
        nullValueCallback.throwCaughtException();
    }

    @Override
    public void scanKeys(List<byte @NonNull []> prefixes, List<? extends IKeyValueCallback> callbacks) throws StorageException {
        List nullValueCallbacks = CollectionUtils.map(callbacks, callback -> new ValueTransformingCallback((IKeyValueCallback)callback, (FunctionWithException<byte[], byte[], StorageException>)((FunctionWithException)value -> null)));
        this.store.scanKeys(prefixes, nullValueCallbacks);
        for (ValueTransformingCallback transformingCallback : nullValueCallbacks) {
            transformingCallback.throwCaughtException();
        }
    }

    @Override
    public Lock obtainLock(String suffix) {
        return this.store.obtainLock(suffix);
    }

    @Override
    public <T extends IStoreCapability> Optional<T> getCapability(Class<T> capability) {
        return this.store.getCapability(capability);
    }

    private PairList<byte[], byte[]> applyTransformationForValues(PairList<byte[], byte[]> keysValues) throws StorageException {
        PairList result = new PairList(keysValues.size());
        for (int i = 0; i < keysValues.size(); ++i) {
            result.add((Object)((byte[])keysValues.getFirst(i)), (Object)this.applyTransformation((byte[])keysValues.getSecond(i)));
        }
        return result;
    }

    private List<byte[]> reverseTransformationForValues(List<byte[]> list) throws StorageException {
        ArrayList<byte[]> result = new ArrayList<byte[]>(list.size());
        for (byte[] value : list) {
            result.add(this.reverseTransformation(value));
        }
        return result;
    }

    protected abstract byte[] reverseTransformation(byte[] var1) throws StorageException;

    protected abstract byte[] applyTransformation(byte[] var1) throws StorageException;

    @ThreadSafe
    private static class ValueTransformingCallback
    extends ExceptionHandlingKeyValueCallbackBase {
        private final IKeyValueCallback delegate;
        private final FunctionWithException<byte[], byte[], StorageException> transformation;

        public ValueTransformingCallback(IKeyValueCallback delegate, FunctionWithException<byte[], byte[], StorageException> transformation) {
            this.delegate = delegate;
            this.transformation = transformation;
        }

        @Override
        protected void callbackWithException(byte[] key, byte[] value) throws StorageException {
            this.delegate.callback(key, (byte[])this.transformation.apply((Object)value));
        }

        @Override
        public void throwCaughtException() throws StorageException {
            IKeyValueCallback iKeyValueCallback = this.delegate;
            if (iKeyValueCallback instanceof ExceptionHandlingKeyValueCallbackBase) {
                ExceptionHandlingKeyValueCallbackBase exceptionHandlingDelegate = (ExceptionHandlingKeyValueCallbackBase)iKeyValueCallback;
                exceptionHandlingDelegate.throwCaughtException();
            }
            super.throwCaughtException();
        }
    }
}

