/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.rest.client.logging;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.Call;
import okhttp3.Connection;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.jetbrains.annotations.NotNull;

public final class LoggingInterceptor
implements Interceptor {
    private static final IntSupplier REQUEST_ID_FACTORY = new AtomicInteger(0)::getAndIncrement;
    private final HttpLoggingInterceptor.Level contentLevel;
    private final Logger logger;
    private final Level loggingLevel;

    public LoggingInterceptor(HttpLoggingInterceptor.Level contentLevel, Level loggingLevel, Logger logger) {
        CCSMAssert.isNotNull((Object)contentLevel, () -> String.format("Expected \"%s\" to be not null", "contentLevel"));
        CCSMAssert.isNotNull((Object)loggingLevel, () -> String.format("Expected \"%s\" to be not null", "loggingLevel"));
        CCSMAssert.isNotNull((Object)logger, () -> String.format("Expected \"%s\" to be not null", "logger"));
        this.contentLevel = contentLevel;
        this.loggingLevel = loggingLevel;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull Response intercept(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Interceptor.Chain chain) throws IOException {
        if (!this.logger.isEnabled(this.loggingLevel) || this.contentLevel == HttpLoggingInterceptor.Level.NONE) {
            return chain.proceed(chain.request());
        }
        int requestId = REQUEST_ID_FACTORY.getAsInt();
        ArrayList<String> messageSnippets = new ArrayList<String>();
        try {
            HttpLoggingInterceptor delegate = new HttpLoggingInterceptor(messageSnippets::add).setLevel(this.contentLevel);
            Response response = delegate.intercept((Interceptor.Chain)new DelegatingChain(chain, () -> this.logger.atLevel(this.loggingLevel).log(this.buildMessage(requestId, messageSnippets, true))));
            return response;
        }
        finally {
            this.logger.atLevel(this.loggingLevel).log(this.buildMessage(requestId, messageSnippets, false));
        }
    }

    private String buildMessage(int requestId, Collection<String> messages, boolean request) {
        String prefix = request ? "Request" : "Response";
        String message = Stream.concat(Stream.of(prefix + ": " + requestId), messages.stream()).collect(Collectors.joining("\n"));
        messages.clear();
        return message;
    }

    private record DelegatingChain(Interceptor.Chain delegate, Runnable onProceed) implements Interceptor.Chain
    {
        public @NonNull Call call() {
            return this.delegate.call();
        }

        public int connectTimeoutMillis() {
            return this.delegate.connectTimeoutMillis();
        }

        public Connection connection() {
            return this.delegate.connection();
        }

        public @NonNull Response proceed(@NonNull Request request) throws IOException {
            this.onProceed.run();
            return this.delegate.proceed(request);
        }

        public int readTimeoutMillis() {
            return this.delegate.readTimeoutMillis();
        }

        public @NonNull Request request() {
            return this.delegate.request();
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull Interceptor.Chain withConnectTimeout(int i, @NonNull TimeUnit timeUnit) {
            return new DelegatingChain(this.delegate.withConnectTimeout(i, timeUnit), this.onProceed);
        }

        @NotNull
        public Interceptor.Chain withReadTimeout(int i, @NonNull TimeUnit timeUnit) {
            return new DelegatingChain(this.delegate.withReadTimeout(i, timeUnit), this.onProceed);
        }

        @NotNull
        public Interceptor.Chain withWriteTimeout(int i, @NonNull TimeUnit timeUnit) {
            return new DelegatingChain(this.delegate.withWriteTimeout(i, timeUnit), this.onProceed);
        }

        public int writeTimeoutMillis() {
            return this.delegate.writeTimeoutMillis();
        }
    }
}

