/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.Collections;
import java.util.Map;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.collections.UnmodifiableCollection;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.collections.UnmodifiableSet;

final class UnmodifiableMapImpl<K, V>
implements UnmodifiableMap<K, V> {
    private static final long serialVersionUID = 1L;
    private final Map<K, V> map;

    public UnmodifiableMapImpl(Map<K, V> map) {
        this.map = Collections.unmodifiableMap(map);
    }

    @Override
    public @NonNull UnmodifiableSet<K> keySet() {
        return UnmodifiableSet.of(this.map.keySet());
    }

    @Override
    public @NonNull UnmodifiableCollection<V> values() {
        return UnmodifiableCollection.of(this.map.values());
    }

    @Override
    public @NonNull UnmodifiableSet<Map.Entry<K, V>> entrySet() {
        return UnmodifiableSet.of(this.map.entrySet());
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return this.map.getOrDefault(key, defaultValue);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.map.forEach(action);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UnmodifiableMapImpl) {
            UnmodifiableMapImpl that = (UnmodifiableMapImpl)o;
            return this.map.equals(that.map);
        }
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }
}

