/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.serialization.classes;

import java.io.IOException;
import org.conqat.lib.commons.serialization.SerializationConsistencyException;
import org.conqat.lib.commons.serialization.classes.SerializedBooleanField;
import org.conqat.lib.commons.serialization.classes.SerializedByteField;
import org.conqat.lib.commons.serialization.classes.SerializedCharField;
import org.conqat.lib.commons.serialization.classes.SerializedDoubleField;
import org.conqat.lib.commons.serialization.classes.SerializedFieldBase;
import org.conqat.lib.commons.serialization.classes.SerializedFloatField;
import org.conqat.lib.commons.serialization.classes.SerializedIntField;
import org.conqat.lib.commons.serialization.classes.SerializedLongField;
import org.conqat.lib.commons.serialization.classes.SerializedShortField;

public abstract class SerializedPrimitiveFieldBase
extends SerializedFieldBase {
    protected SerializedPrimitiveFieldBase(String name) {
        super(name);
    }

    protected <T> T ensureType(Object value, Class<T> type) throws SerializationConsistencyException {
        if (!type.isInstance(value)) {
            String actualType = null;
            if (value != null) {
                actualType = value.getClass().getName();
            }
            throw new SerializationConsistencyException("Would have expected type " + String.valueOf(type) + " for field " + this.getName() + " but was " + actualType);
        }
        return (T)value;
    }

    public static SerializedPrimitiveFieldBase fromTypeCode(char typeCode, String fieldName) throws IOException {
        return switch (typeCode) {
            case 'B' -> new SerializedByteField(fieldName);
            case 'C' -> new SerializedCharField(fieldName);
            case 'D' -> new SerializedDoubleField(fieldName);
            case 'F' -> new SerializedFloatField(fieldName);
            case 'I' -> new SerializedIntField(fieldName);
            case 'J' -> new SerializedLongField(fieldName);
            case 'S' -> new SerializedShortField(fieldName);
            case 'Z' -> new SerializedBooleanField(fieldName);
            default -> throw new SerializationConsistencyException("Unrecognized type code: " + typeCode);
        };
    }
}

