/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.string;

import java.math.BigInteger;
import java.util.Comparator;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class NumbersAwareStringComparator
implements Comparator<String> {
    public static final NumbersAwareStringComparator INSTANCE = new NumbersAwareStringComparator();

    private NumbersAwareStringComparator() {
    }

    @Override
    public int compare(String s1, String s2) {
        if (StringUtils.isEmpty(s1) || StringUtils.isEmpty(s2)) {
            return StringUtils.compare(s1, s2);
        }
        return NumbersAwareStringComparator.naturalSortComparison(s1, s2);
    }

    private static int naturalSortComparison(String a, String b) {
        int[] ai = new int[]{0};
        int[] bi = new int[]{0};
        while (ai[0] < a.length() && bi[0] < b.length()) {
            int currentAi = ai[0];
            int currentBi = bi[0];
            char charA = a.charAt(currentAi);
            char charB = b.charAt(currentBi);
            if (Character.isDigit(charA) && Character.isDigit(charB)) {
                int numberComparison = NumbersAwareStringComparator.compareNumbersAndIncrementIndex(a, b, ai, bi, currentAi, currentBi);
                if (numberComparison == 0) continue;
                return numberComparison;
            }
            int comparison = Character.compare(charA, charB);
            if (comparison != 0) {
                return comparison;
            }
            ai[0] = ai[0] + 1;
            bi[0] = bi[0] + 1;
        }
        return Integer.compare(a.length(), b.length());
    }

    private static int compareNumbersAndIncrementIndex(String a, String b, int[] ai, int[] bi, int currentAi, int currentBi) {
        try {
            return NumbersAwareStringComparator.compareNumberAsLongAndIncrementIndex(a, ai, b, bi);
        }
        catch (NumberFormatException e) {
            ai[0] = currentAi;
            bi[0] = currentBi;
            return NumbersAwareStringComparator.compareNumberAsBigIntegerAndIncrementIndex(a, ai, b, bi);
        }
    }

    private static int compareNumberAsLongAndIncrementIndex(String a, int[] ai, String b, int[] bi) throws NumberFormatException {
        long longA = NumbersAwareStringComparator.consumeNumberAsLongAndIncrementIndex(a, ai);
        long longB = NumbersAwareStringComparator.consumeNumberAsLongAndIncrementIndex(b, bi);
        return Long.compare(longA, longB);
    }

    private static long consumeNumberAsLongAndIncrementIndex(String a, int[] ai) throws NumberFormatException {
        char chari;
        long number = 0L;
        while (ai[0] < a.length() && Character.isDigit(chari = a.charAt(ai[0]))) {
            int c = chari - 48;
            if ((number = number * 10L + (long)c) < 0L) {
                throw new NumberFormatException("Number too large for a Java long. Falling back to BigInteger parsing.");
            }
            ai[0] = ai[0] + 1;
        }
        return number;
    }

    private static int compareNumberAsBigIntegerAndIncrementIndex(String a, int[] ai, String b, int[] bi) {
        String numberA = NumbersAwareStringComparator.getNextNumberSubstringAndIncrementIndex(a, ai);
        String numberB = NumbersAwareStringComparator.getNextNumberSubstringAndIncrementIndex(b, bi);
        return new BigInteger(numberA).compareTo(new BigInteger(numberB));
    }

    private static String getNextNumberSubstringAndIncrementIndex(String a, int[] ai) {
        int startIndex = ai[0];
        while (ai[0] < a.length() && Character.isDigit(a.charAt(ai[0]))) {
            ai[0] = ai[0] + 1;
        }
        return a.substring(startIndex, ai[0]);
    }
}

