/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.core.logging;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.Contract;

public class RateLimiting {
    public static final int DEFAULT_LIMIT_RATE = 100;
    private final int limit;
    private final ConcurrentHashMap<Object, AtomicInteger> countPerMarker = new ConcurrentHashMap();

    public RateLimiting(int limit) {
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }

    @Contract(value="_, null, null, _ -> null; _, !null, !null, _ -> !null", mutates="this")
    public <T> T applyLimit(@NonNull Object marker, T defaultValue, T limitedValue, Runnable onFirstLimited) {
        int invocationCount = this.countPerMarker.computeIfAbsent(marker, ignored -> new AtomicInteger()).incrementAndGet();
        if (invocationCount > this.limit) {
            if (onFirstLimited != null && invocationCount == this.limit + 1) {
                onFirstLimited.run();
            }
            return limitedValue;
        }
        return defaultValue;
    }

    public void reset() {
        this.countPerMarker.clear();
    }

    public void reset(@NonNull Object marker) {
        this.countPerMarker.remove(marker);
    }

    public int getLimitedCount() {
        return this.countPerMarker.values().stream().mapToInt(AtomicInteger::get).filter(count -> count > this.limit).map(count -> count - this.limit).sum();
    }

    public int getLimitedCount(@NonNull Object marker) {
        int invocationCount;
        AtomicInteger count = this.countPerMarker.get(marker);
        int n = invocationCount = count == null ? 0 : count.get();
        if (invocationCount <= this.limit) {
            return 0;
        }
        return invocationCount - this.limit;
    }
}

