/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.core.util;

import com.teamscale.commons.TeamscaleInstallationUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class NativeLibUtil {
    private static final UnmodifiableSet<Path> NATIVES_DIRECTORIES = CollectionUtils.asUnmodifiable(NativeLibUtil.collectNativeDirectories());

    private static Set<Path> collectNativeDirectories() {
        Optional<Path> libNatives = TeamscaleInstallationUtils.locateRootPath((String)"lib/natives").map(Path::toAbsolutePath).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0]));
        if (libNatives.isPresent()) {
            return Collections.singleton(libNatives.get());
        }
        if (EFeatureToggle.ENABLE_DEV_MODE.isEnabled()) {
            return TeamscaleInstallationUtils.getRepositoryDirectories((String)"natives");
        }
        return Collections.emptySet();
    }

    public static @NonNull File getNativeLib(String libName) {
        for (Path nativesDirectory : NATIVES_DIRECTORIES) {
            Path libPath = nativesDirectory.resolve(libName);
            if (!Files.exists(libPath, new LinkOption[0])) continue;
            return libPath.toFile();
        }
        if (NATIVES_DIRECTORIES.isEmpty()) {
            throw new NoSuchElementException("No source directories for native libs were provided.");
        }
        throw new NoSuchElementException("Could not find native lib '%s' in %s".formatted(libName, NATIVES_DIRECTORIES));
    }

    private NativeLibUtil() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

