/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.abap;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.gitbridge.abap.AbapFileMetadataManager;
import com.teamscale.index.metadata.IFileMetadata;
import com.teamscale.index.metadata.TokenElementMetadataIndex;
import com.teamscale.index.metadata.abap.AbapFileMetadata;
import com.teamscale.index.metadata.abap.AbapFileMetadataReader;
import com.teamscale.index.resource.BasicTokenElementIndex;
import eu.cqse.check.framework.scanner.LanguageGroups;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

public class AbapFileMetadataSynchronizer
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    @DeltaSource(value=BasicTokenElementIndex.class)
    private KeyDelta delta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private BasicTokenElementIndex basicTokenElementIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private MetaIndex metaIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private TokenElementMetadataIndex tokenElementMetadataIndex;

    public void execute() throws Exception {
        ProjectConfiguration projectConfiguration = (ProjectConfiguration)this.metaIndex.getValue(ProjectConfiguration.class);
        Set languages = projectConfiguration.getConfiguredLanguages();
        if (languages.stream().anyMatch(LanguageGroups.SAP_LANGUAGES::contains)) {
            this.processDeletedMetadata();
            this.processAddedOrChangedMetadata();
        }
    }

    private void processDeletedMetadata() throws StorageException {
        HashSet<String> deletedFiles = new HashSet<String>();
        for (String file : this.delta.getDeletedKeysAsStrings()) {
            if (AbapFileMetadataManager.hasMetadataRelevance(file)) {
                deletedFiles.add(file);
                continue;
            }
            deletedFiles.add(AbapFileMetadataReader.getFileNameFromMetadataFile((String)file));
        }
        this.tokenElementMetadataIndex.removeMetadata(deletedFiles.stream().toList());
    }

    private void processAddedOrChangedMetadata() throws StorageException {
        PairList filesAndMetadata = new PairList();
        HashSet<String> abapAndMetadataFiles = new HashSet<String>(this.delta.getAddedOrChangedKeysAsStrings());
        List metadataFiles = CollectionUtils.filter(abapAndMetadataFiles, AbapFileMetadataReader::isMetadataFile);
        for (String metaDataFile : metadataFiles) {
            String abapFile = AbapFileMetadataReader.getFileNameFromMetadataFile((String)metaDataFile);
            abapAndMetadataFiles.add(abapFile);
        }
        Map<String, BasicTokenElementInfo> uniformPathsToTokenElements = this.basicTokenElementIndex.getTokenElementsByPath(abapAndMetadataFiles);
        for (String metadataFile : uniformPathsToTokenElements.keySet().stream().filter(AbapFileMetadataReader::isMetadataFile).toList()) {
            String abapFile = AbapFileMetadataReader.getFileNameFromMetadataFile((String)metadataFile);
            if (uniformPathsToTokenElements.get(abapFile) == null) {
                LOGGER.debug("Metadata file {} will not be synchronized. {} is excluded from project configuration.", (Object)metadataFile, (Object)abapFile);
                continue;
            }
            BasicTokenElementInfo elementInfo = uniformPathsToTokenElements.get(metadataFile);
            if (elementInfo == null) {
                LOGGER.warn("No content found for ABAP metadata file {}", (Object)metadataFile);
                continue;
            }
            AbapFileMetadata abapFileMetadata = AbapFileMetadataReader.parseFileContents((String)metadataFile, (String)elementInfo.getText(), arg_0 -> ((Logger)LOGGER).warn(arg_0));
            filesAndMetadata.add(Pair.createPair((Object)abapFile, (Object)abapFileMetadata));
        }
        this.tokenElementMetadataIndex.storeMetadata((PairList<String, ? extends IFileMetadata>)filesAndMetadata);
    }
}

