/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.tga;

import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonDiffEntryExamples;
import com.teamscale.index.admin.instance_comparison.comparison.PredefinedImprovedInstanceComparisonDiffEntry;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.IDetailedInstanceComparisonContribution;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.IInstanceComparisonValue;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.InstanceComparisonContributionBase;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.tga.TestGapAnalysisComparisonContribution;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.tga.TgaTrend;
import com.teamscale.index.testgap.ETestGapState;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.date.DateTimeUtils;

final class TgaTrendInstanceComparisonValue
implements IInstanceComparisonValue {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String key;
    private final TgaTrend testGapTrend;

    TgaTrendInstanceComparisonValue(String key, TgaTrend testGapTrend) {
        this.key = key;
        this.testGapTrend = testGapTrend;
    }

    public Optional<PredefinedImprovedInstanceComparisonDiffEntry> computeDifference(@Nullable IInstanceComparisonValue other, boolean selfIsLocal, InstanceComparisonContributionBase.ComparisonContext context) {
        TgaDifference tgaDifference;
        if (other == null) {
            return Optional.empty();
        }
        if (!(other instanceof TgaTrendInstanceComparisonValue)) {
            LOGGER.warn("Received unsupported other instance ({}: {}) for test gap trend, that cannot be compared with this instance.", other.getClass(), (Object)other);
            return Optional.empty();
        }
        TgaTrendInstanceComparisonValue otherTgaTrend = (TgaTrendInstanceComparisonValue)other;
        UnmodifiableList<TgaTrend.TgaTrendElement> localTrend = this.testGapTrend.getTrendElements();
        UnmodifiableList<TgaTrend.TgaTrendElement> remoteTrend = otherTgaTrend.testGapTrend.getTrendElements();
        if (!selfIsLocal) {
            UnmodifiableList<TgaTrend.TgaTrendElement> tmp = localTrend;
            localTrend = remoteTrend;
            remoteTrend = tmp;
        }
        if ((tgaDifference = TgaTrendInstanceComparisonValue.computeMaximumDeviation(localTrend, remoteTrend)) == null || tgaDifference.getAbsoluteDeviation() == 0) {
            return Optional.empty();
        }
        double acceptedDeviation = context.getAcceptedComparisonDeviation(this.key);
        boolean withinAcceptedDeviation = true;
        for (TgaDifference.Deviation deviation : tgaDifference.deviation.values()) {
            int local = deviation.local;
            int remote = deviation.remote;
            withinAcceptedDeviation &= IInstanceComparisonValue.isWithinAcceptedDeviation(local, remote, acceptedDeviation);
        }
        return Optional.of(PredefinedImprovedInstanceComparisonDiffEntry.fromObject(this.key, TgaTrendInstanceComparisonValue.toHumanReadable(tgaDifference), TgaTrendInstanceComparisonValue.toHumanReadable(tgaDifference.inverse()), InstanceComparisonDiffEntryExamples.EMPTY, false, withinAcceptedDeviation));
    }

    @Override
    public @Nullable IDetailedInstanceComparisonContribution getDetails() {
        return null;
    }

    @Override
    public String getValueHumanReadable() {
        return this.testGapTrend.getTrendElements().stream().map(TgaTrend.TgaTrendElement::getCounts).reduce(new CounterSet(), (a, b) -> {
            CounterSet counterSet = new CounterSet();
            counterSet.add(a);
            counterSet.add(b);
            return counterSet;
        }).toString();
    }

    private static String toHumanReadable(TgaDifference tgaDifference) {
        StringJoiner changePerState = new StringJoiner(", ");
        for (ETestGapState state : TestGapAnalysisComparisonContribution.EXPECTED_TEST_GAP_COUNT_STATES) {
            TgaDifference.Deviation deviation = tgaDifference.deviation().getOrDefault((Object)state, TgaDifference.Deviation.ZERO);
            changePerState.add(String.format("%.0f%% (%d) %s", deviation.relative(), deviation.absolute(), TestGapAnalysisComparisonContribution.getTestGapStateDescription(state)));
        }
        return String.valueOf(changePerState) + " (at " + DateTimeUtils.getUiFormattedDateString((long)tgaDifference.timestamp()) + ")";
    }

    private static TgaDifference computeMaximumDeviation(List<TgaTrend.TgaTrendElement> localTrend, List<TgaTrend.TgaTrendElement> remoteTrend) {
        Comparator<TgaTrend.TgaTrendElement> byTimestamp = Comparator.comparingLong(TgaTrend.TgaTrendElement::getTimestamp);
        TreeSet<TgaTrend.TgaTrendElement> local = new TreeSet<TgaTrend.TgaTrendElement>(byTimestamp);
        local.addAll(localTrend);
        TreeSet<TgaTrend.TgaTrendElement> remote = new TreeSet<TgaTrend.TgaTrendElement>(byTimestamp);
        remote.addAll(remoteTrend);
        TgaDifference result = null;
        for (TgaTrend.TgaTrendElement element : CollectionUtils.asIterable((Iterator)CollectionUtils.sortedIterator(local, remote, (SortedSet[])new SortedSet[0]))) {
            TgaTrend.TgaTrendElement localElement = local.floor(element);
            TgaTrend.TgaTrendElement remoteElement = remote.floor(element);
            if (localElement == null || remoteElement == null) continue;
            TgaDifference difference = TgaDifference.between(localElement, remoteElement);
            if (result != null && TgaDifference.MORE_DEVIATION.compare(result, difference) >= 0) continue;
            result = difference;
        }
        return result;
    }

    private record TgaDifference(long timestamp, Map<ETestGapState, Deviation> deviation) {
        private static final Comparator<TgaDifference> MORE_DEVIATION = Comparator.comparingInt(TgaDifference::getAbsoluteDeviation);

        private int getAbsoluteDeviation() {
            return this.deviation.values().stream().mapToInt(Deviation::absolute).map(Math::abs).sum();
        }

        private TgaDifference inverse() {
            return new TgaDifference(this.timestamp, this.deviation.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Deviation)entry.getValue()).inverse())));
        }

        private static TgaDifference between(TgaTrend.TgaTrendElement local, TgaTrend.TgaTrendElement remote) {
            EnumSet<ETestGapState> allStates = EnumSet.copyOf(local.getCounts().getKeys());
            allStates.addAll((Collection<ETestGapState>)remote.getCounts().getKeys());
            EnumMap<ETestGapState, Deviation> deviations = new EnumMap<ETestGapState, Deviation>(ETestGapState.class);
            for (ETestGapState state : allStates) {
                Deviation deviation = Deviation.between(local.getCounts().getValue((Object)state), remote.getCounts().getValue((Object)state));
                deviations.put(state, deviation);
            }
            return new TgaDifference(Math.max(local.getTimestamp(), remote.getTimestamp()), deviations);
        }

        private record Deviation(int local, int remote) {
            private static final Deviation ZERO = new Deviation(0, 0);

            private static Deviation between(int local, int remote) {
                return new Deviation(local, remote);
            }

            private int absolute() {
                return this.local - this.remote;
            }

            private double relative() {
                if (this.local == 0) {
                    return 0.0;
                }
                if (this.remote == 0) {
                    return Double.NaN;
                }
                return ((double)this.local / (double)this.remote - 1.0) * 100.0;
            }

            private Deviation inverse() {
                return new Deviation(this.remote, this.local);
            }
        }
    }
}

