/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.findings.FindingsIndex;
import com.teamscale.index.architecture.ArchitectureAssessmentIndex;
import com.teamscale.index.architecture.ArchitectureReferenceIndex;
import com.teamscale.index.resource.TokenElementIndex;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class ArchitectureReferenceContentSynchronizer
extends ChangeProcessorAnalysisStep {
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ArchitectureReferenceIndex architectureIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ArchitectureAssessmentIndex assessmentIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private FindingsIndex findingsIndex;
    @DeltaSource(value=TokenElementIndex.class, indexName="content")
    private KeyDelta contentDelta;

    public void execute() throws StorageException {
        List<String> deletedArchitectures = ArchitectureReferenceContentSynchronizer.filterKeys(this.contentDelta.getDeletedKeysAsStrings());
        if (!deletedArchitectures.isEmpty()) {
            this.findingsIndex.removeFindingsForPartitions(deletedArchitectures);
            this.findingsIndex.removeFindingsForPartitionsAndPaths("architecture-orphans", deletedArchitectures);
            this.assessmentIndex.removeAssessments(deletedArchitectures);
            this.architectureIndex.removeArchitectures(deletedArchitectures);
        }
        PairList values = new PairList();
        for (String key : ArchitectureReferenceContentSynchronizer.filterKeys(this.contentDelta.getAddedOrChangedKeysAsStrings())) {
            values.add((Object)key, (Object)this.getSchedulingCommit().getTimestamp());
        }
        if (!values.isEmpty()) {
            this.architectureIndex.setArchitecturesAndChanges((PairList<String, Long>)values);
        }
    }

    private static List<String> filterKeys(List<String> keys) {
        return CollectionUtils.filter(keys, UniformPathUtils::isArchitectureFile);
    }
}

