/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture.incremental;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.architecture.incremental.ArchitectureFileDependenciesIndex;
import com.teamscale.index.architecture.incremental.ArchitectureTypeDependenciesIndex;
import com.teamscale.index.architecture.incremental.FileDependencyCalculator;
import com.teamscale.index.architecture.incremental.TypeDependencyCalculator;
import com.teamscale.index.dependencies.DependencyListIndex;
import com.teamscale.index.dependencies.ProjectModuleIndex;
import com.teamscale.index.dependencies.TypeDependencies;
import com.teamscale.index.dependencies.TypeDependencyIndex;
import com.teamscale.index.dependencies.TypeIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class ArchitectureScopeSynchronizer
extends ChangeProcessorAnalysisStep {
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TypeDependencyIndex typeDependencyIndex;
    @DeltaSource(value=TypeDependencyIndex.class)
    private KeyDelta typeDependencyDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TypeIndex typeIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ProjectModuleIndex projectModuleIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ArchitectureFileDependenciesIndex architectureFileDependencyIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ArchitectureTypeDependenciesIndex architectureTypeDependencyIndex;
    private TypeDependencyCalculator typeDependencyCalculator;
    private FileDependencyCalculator fileDependencyCalculator;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE, indexName="inverse-dependencies")
    private DependencyListIndex inverseDependencyIndex;

    public void execute() throws ConQATException, ExecutionException {
        this.typeDependencyCalculator = new TypeDependencyCalculator(this.typeDependencyIndex, this.typeIndex);
        this.fileDependencyCalculator = new FileDependencyCalculator(this.typeDependencyIndex, this.typeIndex, this.projectModuleIndex);
        this.handleRemovedFiles();
        this.handleRemovedTypes();
        this.handleChangedTypeDependencies();
    }

    private void handleRemovedFiles() throws StorageException {
        List keysToDelete = this.typeDependencyDelta.getDeletedKeysAsStrings();
        keysToDelete.addAll(this.fileDependencyCalculator.getThirdPartyDependencies(keysToDelete));
        this.architectureFileDependencyIndex.removeDependencies(keysToDelete);
    }

    private void handleRemovedTypes() throws StorageException {
        List keysToDelete = this.typeDependencyDelta.getDeletedKeysAsStrings();
        keysToDelete.addAll(this.typeDependencyCalculator.getThirdPartyDependencies(keysToDelete));
        this.architectureTypeDependencyIndex.removeDependencies(keysToDelete);
    }

    private void handleChangedTypeDependencies() throws StorageException {
        List changedUniformPaths = this.typeDependencyDelta.getAddedOrChangedKeysAsStrings();
        List affectedUniformPaths = this.inverseDependencyIndex.getDependencies(changedUniformPaths).stream().filter(Objects::nonNull).flatMap(Collection::stream).toList();
        changedUniformPaths.addAll(affectedUniformPaths);
        HashSet paths = new HashSet(changedUniformPaths);
        PairList<String, ArrayList<TypeDependencies>> typeDependenciesByPath = this.typeDependencyIndex.getTypeDependenciesPerUniformPath(new ArrayList<String>(paths));
        List<TypeDependencies> dependencies = typeDependenciesByPath.extractSecondList().stream().flatMap(Collection::stream).toList();
        Map<String, ListMap<String, ElementLocation>> typeDependencies = this.typeDependencyCalculator.createDependencies(dependencies);
        this.architectureTypeDependencyIndex.storeDependencies(typeDependencies);
        Map<String, ListMap<String, ElementLocation>> fileDependencies = this.fileDependencyCalculator.createDependencies(typeDependenciesByPath);
        this.architectureFileDependencyIndex.storeDependencies(fileDependencies);
    }
}

