/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture.scope;

import com.teamscale.index.architecture.assessment.ComponentOverlapping;
import com.teamscale.index.architecture.commons.EFindingCreationType;
import com.teamscale.index.architecture.commons.EStereotype;
import com.teamscale.index.architecture.scope.ComponentNode;
import com.teamscale.index.architecture.scope.Constraint;
import com.teamscale.index.architecture.scope.DependencyPolicy;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.conqat.engine.commons.util.CommonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.ArchitectureCreationModificationInfo;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.ToStringComparator;
import org.conqat.lib.commons.string.StringUtils;

public class ArchitectureDefinition
extends ComponentNode {
    private Map<String, ComponentNode> nameLookup;
    private final String scopeIncludePattern;
    private final String scopeExcludePattern;
    private Predicate<String> scopeIncludeTest = null;
    private Predicate<String> scopeExcludeTest = null;
    private final boolean fileBased;
    private final boolean legacyCodeMapping;
    private final boolean structureOnly;
    private final EFindingCreationType findingCreation;
    private final List<Constraint> constraints = new ArrayList<Constraint>();
    private ListMap<String, String> redundantIncludePatterns;
    private ComponentOverlapping componentOverlaps;
    private ListMap<String, Integer> numberOfMatches;
    private final Set<String> orphans = new HashSet<String>();
    private ArchitectureCreationModificationInfo creationAndModificationInfo;

    public ArchitectureDefinition(String name, boolean fileBased, EFindingCreationType findingCreation, String scopeIncludePattern, String scopeExcludePattern, ArchitectureCreationModificationInfo creationAndModificationInfo) throws ConQATException {
        this(name, fileBased, findingCreation, scopeIncludePattern, scopeExcludePattern, creationAndModificationInfo, false, false);
    }

    public ArchitectureDefinition(String name, boolean fileBased, EFindingCreationType findingCreation, String scopeIncludePattern, String scopeExcludePattern, ArchitectureCreationModificationInfo creationAndModificationInfo, boolean legacyCodeMapping, boolean structureOnly) throws ConQATException {
        super(name, new Point(0, 0), new Dimension(0, 0), EStereotype.NONE);
        CommonUtils.compilePattern((String)scopeExcludePattern);
        CommonUtils.compilePattern((String)scopeIncludePattern);
        this.fileBased = fileBased;
        this.findingCreation = findingCreation;
        this.scopeIncludePattern = scopeIncludePattern;
        this.scopeExcludePattern = scopeExcludePattern;
        this.creationAndModificationInfo = creationAndModificationInfo;
        this.legacyCodeMapping = legacyCodeMapping;
        this.structureOnly = structureOnly;
    }

    public boolean isLegacyCodeMapping() {
        return this.legacyCodeMapping;
    }

    public boolean isStructureOnly() {
        return this.structureOnly;
    }

    public List<DependencyPolicy> getSortedPolicies() {
        ArrayList<DependencyPolicy> edges = new ArrayList<DependencyPolicy>();
        this.collectPolicies(edges);
        edges.sort((Comparator<DependencyPolicy>)ToStringComparator.INSTANCE);
        return edges;
    }

    public Set<ComponentNode> getAllComponents() {
        HashSet<ComponentNode> components = new HashSet<ComponentNode>();
        components.add(this);
        components.addAll(this.getAllSubComponents());
        return components;
    }

    public synchronized ComponentNode getComponentByName(String name) {
        if (this.nameLookup == null) {
            this.nameLookup = new HashMap<String, ComponentNode>();
            this.fillNameLookup(this.nameLookup);
        }
        return this.nameLookup.get(name);
    }

    public Set<DependencyPolicy> getAllPolicies() {
        IdentityHashSet edges = new IdentityHashSet();
        this.collectPolicies((Collection<DependencyPolicy>)edges);
        return edges;
    }

    public String getScopeIncludePattern() {
        return this.scopeIncludePattern;
    }

    public String getScopeExcludePattern() {
        return this.scopeExcludePattern;
    }

    public boolean isIncludedInScope(String type) {
        return this.getScopeIncludeTest().test(type) && !this.getScopeExcludeTest().test(type);
    }

    private synchronized Predicate<String> getScopeIncludeTest() {
        if (this.scopeIncludeTest == null) {
            this.scopeIncludeTest = !StringUtils.isEmpty((String)this.getScopeIncludePattern()) ? ArchitectureDefinition.compilePattern(this.getScopeIncludePattern()).asMatchPredicate() : ignored -> true;
        }
        return this.scopeIncludeTest;
    }

    private synchronized Predicate<String> getScopeExcludeTest() {
        if (this.scopeExcludeTest == null) {
            this.scopeExcludeTest = !StringUtils.isEmpty((String)this.getScopeExcludePattern()) ? ArchitectureDefinition.compilePattern(this.getScopeExcludePattern()).asMatchPredicate() : ignored -> false;
        }
        return this.scopeExcludeTest;
    }

    private static Pattern compilePattern(String patternRegex) {
        try {
            return Pattern.compile(patternRegex);
        }
        catch (PatternSyntaxException e) {
            throw new AssertionError("Expect only valid regexes in model, as editor performs checking during editing. Failed pattern: " + patternRegex, e);
        }
    }

    public boolean isFileBased() {
        return this.fileBased;
    }

    public EFindingCreationType getFindingCreation() {
        return this.findingCreation;
    }

    public void addConstraint(Constraint constraint) {
        this.constraints.add(constraint);
    }

    public void addConstraints(Collection<Constraint> constraints) {
        this.constraints.addAll(constraints);
    }

    public List<Constraint> getConstraints() {
        return CollectionUtils.asUnmodifiable(this.constraints);
    }

    public List<String> getRedundantIncludePatterns(ComponentNode component) {
        return (List)this.redundantIncludePatterns.getCollectionOrEmpty((Object)component.getName());
    }

    public SetMap<String, String> getComponentOverlaps(ComponentNode component) {
        return this.componentOverlaps.getOverlaps(component);
    }

    public List<Integer> getNumberOfMatches(ComponentNode component) {
        return (List)this.numberOfMatches.getCollectionOrEmpty((Object)component.getName());
    }

    public Set<String> getOrphans() {
        return CollectionUtils.asUnmodifiable(this.orphans);
    }

    public void setOrphans(Collection<String> orphans) {
        this.orphans.clear();
        this.orphans.addAll(orphans);
    }

    public ArchitectureCreationModificationInfo getCreationAndModificationInfo() {
        return this.creationAndModificationInfo;
    }

    public void setRedundantIncludePatterns(ListMap<String, String> redundantIncludePatterns) {
        this.redundantIncludePatterns = redundantIncludePatterns;
    }

    public void setNumberOfMatches(ListMap<String, Integer> numberOfMatches) {
        this.numberOfMatches = numberOfMatches;
    }

    public void setCreationAndModificationInfo(ArchitectureCreationModificationInfo creationAndModificationInfo) {
        this.creationAndModificationInfo = creationAndModificationInfo;
    }

    public void setComponentOverlaps(ComponentOverlapping componentOverlaps) {
        this.componentOverlaps = componentOverlaps;
    }
}

