/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.backup.snapshot;

import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.index.backup.BackupTargetFactory;
import com.teamscale.index.backup.IBackupTarget;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.capability.ISnapshotBackupCapability;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class StorageSnapshotBackupUtils {
    private static final int STORE_DATA_END = -1;
    private static final int NEXT_STORE_MARKER_VALUE = 42;
    private static final byte[] INT_READ_BUFFER = new byte[4];
    private static final int WRITE_BATCH_SIZE = 1000;

    public static IBackupTarget writeSnapshotBackup(String targetUriString, IndexLayer indexLayer) throws StorageException {
        ExternalCredentialsIndex externalCredentialsIndex = (ExternalCredentialsIndex)indexLayer.openGlobalIndex(ExternalCredentialsIndex.class);
        ISnapshotBackupCapability snapshotBackupCapability = (ISnapshotBackupCapability)indexLayer.getRawStorageSystemProvider().getCapability(ISnapshotBackupCapability.class).orElseThrow(() -> new AssertionError((Object)"Storage system does not support snapshot backups!"));
        IBackupTarget target = BackupTargetFactory.getWriteTarget(targetUriString, externalCredentialsIndex, null, null);
        try (GZIPOutputStream outputStream = new GZIPOutputStream(target.getOutputStream());){
            StorageSnapshotBackupUtils.writeString(EStorageSystemVersion.CURRENT_VERSION.name(), outputStream);
            snapshotBackupCapability.createSnapshotBackup(StorageSnapshotBackupUtils.initSnapshotConsumer(outputStream));
            StorageSnapshotBackupUtils.writeInt(-1, outputStream);
        }
        catch (IOException e) {
            throw new StorageException("Failed to write snapshot backup: " + e.getMessage(), (Throwable)e);
        }
        try {
            target.completeBackup();
        }
        catch (IOException e) {
            throw new StorageException("Failed to complete snapshot backup: " + e.getMessage(), (Throwable)e);
        }
        return target;
    }

    private static ISnapshotBackupCapability.ISnapshotConsumer initSnapshotConsumer(final OutputStream outputStream) {
        return new ISnapshotBackupCapability.ISnapshotConsumer(){

            public void writeKeyValue(byte[] key, byte[] value) throws IOException {
                StorageSnapshotBackupUtils.writeByteArray(key, outputStream);
                StorageSnapshotBackupUtils.writeByteArray(value, outputStream);
            }

            public void startStore(String partitionName, String storeName) throws IOException {
                StorageSnapshotBackupUtils.writeInt(42, outputStream);
                StorageSnapshotBackupUtils.writeString(partitionName, outputStream);
                StorageSnapshotBackupUtils.writeString(storeName, outputStream);
            }

            public void endStore() throws IOException {
                StorageSnapshotBackupUtils.writeInt(-1, outputStream);
            }
        };
    }

    private static void writeString(String string, OutputStream outputStream) throws IOException {
        StorageSnapshotBackupUtils.writeByteArray(StringUtils.stringToBytes((String)string), outputStream);
    }

    private static void writeByteArray(byte[] array, OutputStream outputStream) throws IOException {
        StorageSnapshotBackupUtils.writeInt(array.length, outputStream);
        outputStream.write(array);
    }

    private static void writeInt(int value, OutputStream outputStream) throws IOException {
        outputStream.write(ByteArrayUtils.intToByteArray((int)value));
    }

    public static void readSnapshotBackup(String sourceUriString, IndexLayer indexLayer) throws StorageException, IOException {
        IBackupTarget target = BackupTargetFactory.getReadTarget(sourceUriString, null, null, null);
        try (GZIPInputStream inputStream = new GZIPInputStream(Channels.newInputStream(target.getReadChannel()));){
            String version = StorageSnapshotBackupUtils.readString(inputStream);
            if (!EStorageSystemVersion.CURRENT_VERSION.name().equals(version)) {
                throw new IOException("Version mismatch. Expected storage version of " + String.valueOf(EStorageSystemVersion.CURRENT_VERSION) + " but backup file provides " + version);
            }
            int nextStoreMarker = StorageSnapshotBackupUtils.readInt(inputStream);
            while (nextStoreMarker != -1) {
                if (nextStoreMarker != 42) {
                    throw new IOException("Expected marker for next store but received " + nextStoreMarker);
                }
                StorageSnapshotBackupUtils.importStore(indexLayer, inputStream);
                nextStoreMarker = StorageSnapshotBackupUtils.readInt(inputStream);
            }
        }
    }

    private static void importStore(IndexLayer indexLayer, InputStream inputStream) throws IOException, StorageException {
        String partition = StorageSnapshotBackupUtils.readString(inputStream);
        String storeName = StorageSnapshotBackupUtils.readString(inputStream);
        IStore store = indexLayer.getRawStorageSystemProvider().openStorageSystem(partition).openStore(storeName);
        PairList writeBuffer = new PairList();
        int size = StorageSnapshotBackupUtils.readInt(inputStream);
        while (size != -1) {
            byte[] key = StorageSnapshotBackupUtils.readArray(size, inputStream);
            byte[] value = StorageSnapshotBackupUtils.readArray(StorageSnapshotBackupUtils.readInt(inputStream), inputStream);
            writeBuffer.add((Object)key, (Object)value);
            size = StorageSnapshotBackupUtils.readInt(inputStream);
            if (writeBuffer.size() < 1000) continue;
            store.put(writeBuffer);
            writeBuffer.clear();
        }
        if (!writeBuffer.isEmpty()) {
            store.put(writeBuffer);
        }
    }

    private static String readString(InputStream inputStream) throws IOException {
        int count = StorageSnapshotBackupUtils.readInt(inputStream);
        if (count <= 0) {
            throw new IOException("Unexpected string size of " + count);
        }
        byte[] data = StorageSnapshotBackupUtils.readArray(count, inputStream);
        return StringUtils.bytesToString((byte[])data);
    }

    private static int readInt(InputStream inputStream) throws IOException {
        FileSystemUtils.safeRead((InputStream)inputStream, (byte[])INT_READ_BUFFER);
        return ByteArrayUtils.byteArrayToInt((byte[])INT_READ_BUFFER);
    }

    private static byte[] readArray(int count, InputStream inputStream) throws IOException {
        byte[] data = new byte[count];
        FileSystemUtils.safeRead((InputStream)inputStream, (byte[])data);
        return data;
    }

    private StorageSnapshotBackupUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

