/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones;

import com.google.common.base.Preconditions;
import com.teamscale.index.code_clones.CloneChunkByPathIndex;
import com.teamscale.index.code_clones.CloneClassInfo;
import com.teamscale.index.code_clones.CloneInfo;
import com.teamscale.index.code_clones.core.Clone;
import com.teamscale.index.code_clones.core.CloneClass;
import java.lang.invoke.CallSite;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.string.StringUtils;

class CloneToInfoConverter {
    private final Map<String, CloneClassInfo> newCloneClassValues;
    private final Map<CloneClass, String> cachedCloneClassIds = new IdentityHashMap<CloneClass, String>();

    CloneToInfoConverter(Map<String, CloneClassInfo> newCloneClassValues) {
        Preconditions.checkNotNull(newCloneClassValues);
        this.newCloneClassValues = newCloneClassValues;
    }

    public @NonNull ArrayList<CloneInfo> convertClones(@NonNull Collection<Clone> clones) {
        Preconditions.checkNotNull(clones);
        ArrayList<CloneInfo> result = new ArrayList<CloneInfo>(clones.size());
        for (Clone clone : clones) {
            result.add(this.convertClone(clone));
        }
        Collections.sort(result);
        return result;
    }

    private @NonNull CloneInfo convertClone(@NonNull Clone clone) {
        String cloneClassId = this.getOrCreateCloneClassId(Objects.requireNonNull(clone.getCloneClass()));
        this.updateCloneClassValues(clone.getCloneClass(), cloneClassId);
        return new CloneInfo(clone.getUniformPath(), clone.getLocation().getRawStartLine(), clone.getLocation().getRawEndLine(), clone.getLengthInUnits(), cloneClassId);
    }

    private String getOrCreateCloneClassId(@NonNull CloneClass cloneClass) {
        return this.cachedCloneClassIds.computeIfAbsent(cloneClass, CloneToInfoConverter::computeCloneClassId);
    }

    private static @NonNull String computeCloneClassId(@NonNull CloneClass cloneClass) {
        ArrayList<CallSite> cloneDescriptions = new ArrayList<CallSite>(cloneClass.size());
        for (Clone clone : cloneClass.getClones()) {
            cloneDescriptions.add((CallSite)((Object)(clone.getUniformPath() + ":" + clone.getLocation().getRawStartLine() + ":" + clone.getLocation().getRawEndLine())));
        }
        cloneDescriptions.sort(Comparator.naturalOrder());
        return Long.toHexString(CloneChunkByPathIndex.HASH_FACTORY.hash64().hash(ByteBuffer.wrap(StringUtils.stringToBytes((String)StringUtils.concat(cloneDescriptions))), 0L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCloneClassValues(CloneClass cloneClass, String cloneClassId) {
        Map<String, CloneClassInfo> map = this.newCloneClassValues;
        synchronized (map) {
            if (this.newCloneClassValues.containsKey(cloneClassId)) {
                return;
            }
            CloneClassInfo cloneClassInfo = new CloneClassInfo();
            this.newCloneClassValues.put(cloneClassId, cloneClassInfo);
            this.convertClones(cloneClass.getClones()).forEach(cloneClassInfo::addClone);
            cloneClassInfo.sortClones();
        }
    }
}

