/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones;

import com.teamscale.index.code_clones.core.Clone;
import com.teamscale.index.code_clones.core.Unit;
import com.teamscale.index.code_clones.core.WiaWordUnit;
import com.teamscale.wia.WiaUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.findings.location.ManualTestCaseTextRegionLocation;
import org.conqat.engine.commons.findings.location.TeamscaleIssueFieldLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.reflect.TypeConversionException;
import org.conqat.lib.commons.region.Region;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class CloneWiaUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<ELanguage> SUPPORTED_LANGUAGES = CollectionUtils.asUnmodifiable(EnumSet.of(ELanguage.NL_TESTS));

    public static Optional<TextRegionLocation> getWorkItemCloneLocation(Clone clone) {
        if (!WiaUtils.isWorkItemPath((String)clone.getUniformPath())) {
            return Optional.empty();
        }
        List<Unit> units = clone.getUnits();
        if (units.isEmpty()) {
            LOGGER.error("WIA clone with empty units: {}", (Object)clone);
            return Optional.empty();
        }
        try {
            WiaWordUnit firstCloneUnit = CloneWiaUtils.toWiaWordUnit(units.get(0));
            WiaWordUnit lastCloneUnit = CloneWiaUtils.toWiaWordUnit(units.get(units.size() - 1));
            ArrayList<ManualTestCaseTextRegionLocation.GapLocation> gapLocations = new ArrayList<ManualTestCaseTextRegionLocation.GapLocation>();
            if (clone.containsGaps()) {
                int cloneStartElementIndex = firstCloneUnit.getIndexInElement();
                for (Region gap : clone.getGaps()) {
                    WiaWordUnit firstGapUnit = CloneWiaUtils.toWiaWordUnit(units.get(gap.getStart() - cloneStartElementIndex));
                    WiaWordUnit lastGapUnit = CloneWiaUtils.toWiaWordUnit(units.get(gap.getEnd() - cloneStartElementIndex));
                    gapLocations.add(CloneWiaUtils.buildCloneGapLocation(firstGapUnit, lastGapUnit));
                }
            }
            return CloneWiaUtils.buildWorkItemCloneLocation(firstCloneUnit, lastCloneUnit, gapLocations);
        }
        catch (TypeConversionException e) {
            LOGGER.error("Inconsistent unit types in WIA clone: {}", (Object)clone, (Object)e);
            return Optional.empty();
        }
    }

    private static WiaWordUnit toWiaWordUnit(Unit unit) throws TypeConversionException {
        if (!(unit instanceof WiaWordUnit)) {
            throw new TypeConversionException("Inconsistent WIA unit type: `%s` should be `%s` for unit %s".formatted(unit.getClass().getSimpleName(), WiaWordUnit.class.getSimpleName(), unit));
        }
        WiaWordUnit wiaUnit = (WiaWordUnit)unit;
        return wiaUnit;
    }

    private static ManualTestCaseTextRegionLocation.GapLocation buildCloneGapLocation(WiaWordUnit firstGapUnit, WiaWordUnit lastGapUnit) {
        ManualTestCaseTextRegionLocation firstLocation = firstGapUnit.getLocation();
        ManualTestCaseTextRegionLocation lastLocation = lastGapUnit.getLocation();
        return new ManualTestCaseTextRegionLocation.GapLocation(new ManualTestCaseTextRegionLocation.TestStepCellIdentifier(firstLocation.getStartStepIndex(), firstLocation.startsInStepAction()), new ManualTestCaseTextRegionLocation.TestStepCellIdentifier(lastLocation.getEndStepIndex(), lastLocation.endsInStepAction()), firstLocation.getFieldStartOffset(), lastLocation.getFieldEndOffset());
    }

    private static Optional<TextRegionLocation> buildWorkItemCloneLocation(WiaWordUnit firstCloneUnit, WiaWordUnit lastCloneUnit, List<ManualTestCaseTextRegionLocation.GapLocation> gapLocations) {
        ManualTestCaseTextRegionLocation firstLocation = firstCloneUnit.getLocation();
        ManualTestCaseTextRegionLocation lastLocation = lastCloneUnit.getLocation();
        if (!firstLocation.getUniformPath().equals(lastLocation.getUniformPath())) {
            LOGGER.error("WIA clone with inconsistent unit paths: '{}' and '{}'", (Object)firstLocation.getUniformPath(), (Object)lastLocation.getUniformPath());
            return Optional.empty();
        }
        ManualTestCaseTextRegionLocation location = new ManualTestCaseTextRegionLocation(firstLocation.getUniformPath(), firstLocation.getIssueId(), new TeamscaleIssueFieldLocation.RawAndFieldSpecific(firstLocation.getRawStartOffset(), firstLocation.getFieldStartOffset()), new TeamscaleIssueFieldLocation.RawAndFieldSpecific(lastLocation.getRawEndOffset(), lastLocation.getFieldEndOffset()), new TeamscaleIssueFieldLocation.RawAndFieldSpecific(firstLocation.getRawStartLine(), firstLocation.getFieldStartLine()), new TeamscaleIssueFieldLocation.RawAndFieldSpecific(lastLocation.getRawEndLine(), lastLocation.getFieldEndLine()), firstLocation.getStartStepIndex(), firstLocation.startsInStepAction(), lastLocation.getEndStepIndex(), lastLocation.endsInStepAction(), firstLocation.getAffectedField(), gapLocations);
        return Optional.of(location);
    }

    public static boolean isUnsupportedWiaLanguage(@Nullable ELanguage language) {
        return WiaUtils.isWiaEnabledLanguage((ELanguage)language) && !SUPPORTED_LANGUAGES.contains(language);
    }

    public static Set<ELanguage> getSupportedLanguages() {
        return SUPPORTED_LANGUAGES;
    }

    public static boolean containsSupportedLanguage(Set<ELanguage> languages) {
        return SUPPORTED_LANGUAGES.stream().anyMatch(languages::contains);
    }

    private CloneWiaUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

