/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones.core;

import com.google.common.base.Preconditions;
import com.teamscale.index.code_clones.core.CloneClass;
import com.teamscale.index.code_clones.core.Unit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.region.Region;
import org.conqat.lib.commons.region.SimpleRegion;

public class Clone {
    private @Nullable CloneClass cloneClass;
    private final @NonNull TextRegionLocation location;
    private final int startUnitIndexInElement;
    private final int lengthInUnits;
    private @Nullable List<Region> gaps;
    private @Nullable String component = null;
    private @Nullable List<Unit> units;

    public Clone(@Nullable CloneClass cloneClass, @NonNull TextRegionLocation location, int startUnitIndexInElement, int lengthInUnits) {
        Preconditions.checkNotNull((Object)location);
        this.cloneClass = cloneClass;
        this.location = location;
        this.startUnitIndexInElement = startUnitIndexInElement;
        this.lengthInUnits = lengthInUnits;
        Preconditions.checkArgument((location.getRawEndOffset() >= location.getRawStartOffset() ? 1 : 0) != 0, (String)"Length must not be negative: %s", (Object)this);
        if (cloneClass != null) {
            cloneClass.add(this);
        }
    }

    public Clone(@Nullable CloneClass cloneClass, @NonNull TextRegionLocation location, @Nullable String component, int startUnitIndexInElement, int lengthInUnits) {
        this(cloneClass, location, startUnitIndexInElement, lengthInUnits);
        this.component = component;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Clone)) {
            return false;
        }
        Clone other = (Clone)obj;
        if (!this.location.getUniformPath().equals(other.location.getUniformPath())) {
            return false;
        }
        if (this.getStartUnitIndexInElement() != other.getStartUnitIndexInElement()) {
            return false;
        }
        if (this.getLengthInUnits() != other.getLengthInUnits()) {
            return false;
        }
        if (!Objects.equals(this.component, other.component)) {
            return false;
        }
        if (this.gapCount() != other.gapCount()) {
            return false;
        }
        for (int i = 0; i < this.gapCount(); ++i) {
            if (this.gaps.get(i).equalsStartEnd((SimpleRegion)other.gaps.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.location.getUniformPath(), this.getStartUnitIndexInElement(), this.getLengthInUnits());
    }

    public @Nullable CloneClass getCloneClass() {
        return this.cloneClass;
    }

    public int getStartUnitIndexInElement() {
        return this.startUnitIndexInElement;
    }

    public int getLengthInUnits() {
        return this.lengthInUnits;
    }

    public @NonNull TextRegionLocation getLocation() {
        return this.location;
    }

    public String getUniformPath() {
        return this.location.getUniformPath();
    }

    public boolean containsGaps() {
        return this.gaps != null && !this.gaps.isEmpty();
    }

    public int gapCount() {
        if (this.gaps == null) {
            return 0;
        }
        return this.gaps.size();
    }

    public @NonNull UnmodifiableList<Region> getGaps() {
        if (this.gaps == null) {
            return CollectionUtils.emptyList();
        }
        return CollectionUtils.asUnmodifiable(this.gaps);
    }

    public void addGap(Region gapRegion) {
        if (this.gaps == null) {
            this.gaps = new ArrayList<Region>();
        }
        this.gaps.add(gapRegion);
    }

    public String toString() {
        if (this.component != null) {
            return "Clone [" + this.component + ":" + this.location.toLocationString() + "]";
        }
        return "Clone [" + this.location.toLocationString() + "]";
    }

    void setCloneClass(@Nullable CloneClass cloneClass) {
        this.cloneClass = cloneClass;
    }

    public @Nullable List<Unit> getUnits() {
        return this.units;
    }

    public void setUnits(@Nullable List<Unit> units) {
        this.units = units;
    }

    public @Nullable String getComponent() {
        return this.component;
    }

    public void setComponent(@Nullable String component) {
        this.component = component;
    }
}

