/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.commons.service.ServiceUtils;
import eu.cqse.check.framework.core.EFindingEnablement;
import java.io.Serializable;
import java.util.Optional;
import java.util.StringJoiner;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class ExternalFindingsDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String NAME_PROPERTY = "name";
    private static final String TYPE_ID_PROPERTY = "typeId";
    private static final String DESCRIPTION_PROPERTY = "description";
    private static final String ENABLEMENT_PROPERTY = "enablement";
    @JsonProperty(value="name")
    private @Nullable String name;
    @JsonProperty(value="typeId")
    private final String typeId;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="enablement")
    private EFindingEnablement enablement;

    @JsonCreator
    public ExternalFindingsDescription(@JsonProperty(value="typeId") String typeId, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="enablement") EFindingEnablement enablement) {
        this.typeId = typeId;
        this.name = name;
        this.description = description;
        this.enablement = enablement;
    }

    public ExternalFindingsDescription(String typeId, String description, EFindingEnablement enablement) {
        this(typeId, typeId, description, enablement);
    }

    public String getDescription() {
        return this.description;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public EFindingEnablement getEnablement() {
        return this.enablement;
    }

    public String toString() {
        return "ExternalFindingDescription[" + this.typeId + ", " + String.valueOf(this.enablement) + ", '" + this.description + "']";
    }

    public int hashCode() {
        return this.typeId.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExternalFindingsDescription)) {
            return false;
        }
        ExternalFindingsDescription other = (ExternalFindingsDescription)obj;
        return other.typeId.equals(this.typeId);
    }

    public String getName() {
        if (!StringUtils.isEmpty((String)this.name)) {
            return this.name;
        }
        return this.typeId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEnablement(EFindingEnablement enablement) {
        this.enablement = enablement;
    }

    public Optional<String> validateIdentifiers() {
        StringJoiner errorMessageJoiner = new StringJoiner(", ");
        ServiceUtils.getErrorMessageForInvalidIdentifiers((String)this.getTypeId(), (String)"Type id").ifPresent(errorMessageJoiner::add);
        ServiceUtils.getErrorMessageForInvalidIdentifiers((String)this.getName(), (String)"Name").ifPresent(errorMessageJoiner::add);
        if (errorMessageJoiner.length() > 0) {
            return Optional.of(errorMessageJoiner.toString());
        }
        return Optional.empty();
    }
}

