/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools.message;

import com.teamscale.index.configuration.tools.MypyConfiguration;
import com.teamscale.index.configuration.tools.message.IMessageManager;
import eu.cqse.check.framework.core.EFindingEnablement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.string.StringUtils;

public class MypyMessageManager
implements IMessageManager {
    public static final String MYPY_FINDINGS_CATEGORY_NAME = "Mypy";
    public static final String MYPY_ANALYSIS_GROUP_NAME = "Mypy";
    private static final String RULES_FILE = "mypy/rules.txt";
    private static final String FIELD_SEPARATOR = ":#:";
    private static final int FIELD_COUNT_PER_LINE = 3;
    private static MypyMessageManager instance;
    private final HashMap<String, MypyRule> mypyRulesByErrorCode = new HashMap();

    public MypyMessageManager() {
        List rules = Resource.of(MypyConfiguration.class, (String)RULES_FILE).getLines();
        MypyMessageManager.parseRules(rules).forEach(rule -> this.mypyRulesByErrorCode.put(rule.errorCode, (MypyRule)rule));
    }

    @Override
    public String getFindingCategoryName() {
        return "Mypy";
    }

    @Override
    public String getFindingsGroupNameFor(String errorCode) {
        if (this.hasRule(errorCode)) {
            return errorCode;
        }
        return null;
    }

    @Override
    public String getReadableNameFor(String errorCode) {
        if (this.hasRule(errorCode)) {
            return this.mypyRulesByErrorCode.get((Object)errorCode).errorName;
        }
        return null;
    }

    @Override
    public boolean hasRule(String errorCode) {
        return this.mypyRulesByErrorCode.containsKey(errorCode);
    }

    public Collection<MypyRule> getMypyRules() {
        return this.mypyRulesByErrorCode.values();
    }

    private static List<MypyRule> parseRules(List<String> ruleFileLines) {
        ArrayList<MypyRule> parsedRules = new ArrayList<MypyRule>();
        for (String line : ruleFileLines) {
            EFindingEnablement defaultEnablement;
            String[] parts = StringUtils.splitByWholeSeparator((String)line, (String)FIELD_SEPARATOR);
            if (parts.length != 3) continue;
            String errorCode = parts[0];
            String errorName = parts[1];
            String enablement = parts[2];
            try {
                defaultEnablement = Enum.valueOf(EFindingEnablement.class, enablement);
            }
            catch (IllegalArgumentException ex) {
                defaultEnablement = EFindingEnablement.AUTO;
            }
            parsedRules.add(new MypyRule(errorCode, errorName, defaultEnablement));
        }
        return parsedRules;
    }

    public static synchronized MypyMessageManager getInstance() {
        if (instance == null) {
            instance = new MypyMessageManager();
        }
        return instance;
    }

    public static class MypyRule {
        public final String errorCode;
        public final String errorName;
        public final EFindingEnablement defaultEnablement;

        private MypyRule(String errorCode, String errorName, EFindingEnablement defaultEnablement) {
            CCSMAssert.isNotNull((Object)errorCode);
            CCSMAssert.isNotNull((Object)errorName);
            CCSMAssert.isNotNull((Object)defaultEnablement);
            this.errorCode = errorCode;
            this.errorName = errorName;
            this.defaultEnablement = defaultEnablement;
        }
    }
}

