/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.cpp;

import com.teamscale.index.dependencies.DependencyExtractorBase;
import com.teamscale.index.dependencies.TypeDependencies;
import com.teamscale.index.dependencies.cpp.CppDependencyUtils;
import com.teamscale.index.dependencies.cpp.CppTypeExtractor;
import com.teamscale.index.resource.CompilationCommand;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.preprocessor.c.CPreprocessor;
import eu.cqse.check.framework.preprocessor.c.IncludeDirective;
import eu.cqse.check.framework.preprocessor.c.PreprocessorIncludeTokenReplacement;
import eu.cqse.check.framework.preprocessor.c.PreprocessorTokenReplacement;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.LanguageGroups;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;

public class CppDependencyExtractor
extends DependencyExtractorBase {
    public static final EnumSet<ELanguage> ACCEPTED_LANGUAGES = LanguageGroups.C_CPP_AND_MS_CLI;
    private final SetMap<String, ElementLocation> dependencies = new SetMap();

    @Override
    protected List<TypeDependencies> extractDependencies(TokenElementInfo tokenElementInfo) throws ConQATException {
        this.extractDependenciesForPreprocessedIncludeDirectives(tokenElementInfo);
        this.extractMethodDependencies(tokenElementInfo);
        if (this.settings.findCppDependenciesInExcludedCode) {
            this.extractDependenciesFromNonPreprocessedCode(tokenElementInfo);
        }
        ListMap dependenciesListMap = new ListMap();
        for (Map.Entry entry : this.dependencies.entrySet()) {
            dependenciesListMap.addAll((Object)((String)entry.getKey()), (Collection)entry.getValue());
        }
        return Collections.singletonList(new TypeDependencies(this.uniformPath, (ListMap<String, ElementLocation>)dependenciesListMap));
    }

    private void extractDependenciesFromNonPreprocessedCode(TokenElementInfo tokenElementInfo) throws StorageException {
        CompilationCommand compilationCommand = this.dependencyExtractionIndexes.compileCommandIndex.getCommands(Collections.singletonList(tokenElementInfo.getUniformPath())).get(0);
        List<ShallowEntity> dirtyRootEntities = tokenElementInfo.getRawShallowEntities();
        List dirtyTokens = dirtyRootEntities.get(0).getAllTokensOfFile();
        for (IToken dirtyToken : dirtyTokens) {
            if (!CPreprocessor.isIncludeDirectiveToken((IToken)dirtyToken)) continue;
            IncludeDirective.createFromTokens(Collections.singletonList(dirtyToken)).forEach(includeDirective -> this.addHeaderInclude((IncludeDirective)includeDirective, this.createLocation(dirtyToken), compilationCommand));
        }
        List methodEntities = ShallowEntityTraversalUtils.listEntitiesOfTypes(dirtyRootEntities, EnumSet.of(EShallowEntityType.METHOD));
        methodEntities.removeIf(Predicate.not(ShallowEntity::isCompleted));
        for (ShallowEntity entity : methodEntities) {
            this.extractDependencyFromMethodEntity(entity);
        }
    }

    private void extractDependenciesForPreprocessedIncludeDirectives(TokenElementInfo tokenElementInfo) throws StorageException {
        List<PreprocessorTokenReplacement> tokenReplacements = this.dependencyExtractionIndexes.preprocessorExpansionsIndex.getExpansionsForUniformPath(tokenElementInfo.getUniformPath());
        for (PreprocessorTokenReplacement tokenReplacement : tokenReplacements) {
            IToken startToken;
            IncludeDirective includeDirective;
            if (tokenReplacement instanceof PreprocessorIncludeTokenReplacement) {
                PreprocessorIncludeTokenReplacement includeReplacement = (PreprocessorIncludeTokenReplacement)tokenReplacement;
                this.addResolvedHeaderDependency(includeReplacement, includeReplacement.buildLocationForReplacedTokens(tokenElementInfo.getTokens(), tokenElementInfo.getUniformPath()));
                continue;
            }
            if (tokenReplacement.originalTokensEndIndex - tokenReplacement.originalTokensStartIndex != 1 || (includeDirective = (IncludeDirective)IncludeDirective.createFromToken((IToken)(startToken = (IToken)tokenElementInfo.getTokens().get(tokenReplacement.originalTokensStartIndex))).orElse(null)) == null) continue;
            String uniformPath1 = tokenElementInfo.getUniformPath();
            TextRegionLocation location = new TextRegionLocation(uniformPath1, startToken.getOffset(), startToken.getOffset() + startToken.getText().length(), startToken.getLineNumber() + 1, startToken.getLineNumber() + StringUtils.countLines((String)startToken.getText()));
            this.addUnresolvedHeaderDependency(includeDirective, location);
        }
    }

    private void addResolvedHeaderDependency(PreprocessorIncludeTokenReplacement includeReplacement, TextRegionLocation location) {
        String resolvedUniformPath = includeReplacement.uniformPathOfIncludedFile;
        String resolvedHeaderType = CppTypeExtractor.getResolvedHeaderType(resolvedUniformPath, this.settings.performCaseSensitiveHeaderResolution);
        this.addDependency(resolvedHeaderType, location);
    }

    private void addUnresolvedHeaderDependency(IncludeDirective includeDirective, TextRegionLocation location) {
        String includedFilePath = CppDependencyExtractor.cleanupIncludedFilePath(includeDirective.getIncludedFilePath());
        String unresolvedHeaderType = CppTypeExtractor.getUnresolvedHeaderType(includedFilePath, this.settings.performCaseSensitiveHeaderResolution);
        this.addDependency(unresolvedHeaderType, location);
    }

    private void extractMethodDependencies(TokenElementInfo tokenElementInfo) {
        UnmodifiableList<ShallowEntity> rootEntities = tokenElementInfo.getShallowEntitiesWithPreprocessorTokens();
        for (ShallowEntity entity : ShallowEntityTraversalUtils.listEntitiesOfTypes(rootEntities, EnumSet.of(EShallowEntityType.METHOD))) {
            this.extractDependencyFromMethodEntity(entity);
        }
    }

    private void extractDependencyFromMethodEntity(ShallowEntity entity) {
        if (!CppDependencyExtractor.isMethodDeclaration(entity) || CppDependencyExtractor.isPureVirtual(entity)) {
            return;
        }
        String methodName = CppDependencyUtils.getMethodName(entity);
        if (methodName == null) {
            return;
        }
        this.addDependency(CppTypeExtractor.getMethodType(methodName), this.createLocation(entity));
    }

    private static boolean isMethodDeclaration(ShallowEntity entity) {
        return entity.getSubtype().endsWith("declaration");
    }

    private static boolean isPureVirtual(ShallowEntity method) {
        UnmodifiableList tokens = method.includedTokens();
        int length = tokens.size();
        return length > 3 && ((IToken)tokens.get(length - 3)).getType() == ETokenType.EQ && ((IToken)tokens.get(length - 2)).getText().equals("0");
    }

    private TextRegionLocation createLocation(ShallowEntity entity) {
        return CppDependencyExtractor.createLocation(this.uniformPath, (List<IToken>)entity.includedTokens());
    }

    private TextRegionLocation createLocation(IToken token) {
        return CppDependencyExtractor.createLocation(this.uniformPath, Collections.singletonList(token));
    }

    private void addDependency(String dependency, TextRegionLocation location) {
        if (this.settings.includeThirdPartyDependencies || this.typeLookupEnvironment.isKnownType(dependency)) {
            this.dependencies.add((Object)dependency, (Object)location);
        }
    }

    private void addHeaderInclude(IncludeDirective includeDirective, TextRegionLocation location, @Nullable CompilationCommand compilationCommand) {
        String dependencyTarget = this.getDependenciesWithBuildSystemInfos(includeDirective, compilationCommand);
        this.addDependency(dependencyTarget, location);
    }

    private static @NonNull String cleanupIncludedFilePath(String includedFilePath) {
        String cleanIncludedFilePath = FileSystemUtils.normalizeSeparatorsPlatformIndependently((String)includedFilePath);
        cleanIncludedFilePath = UniformPathUtils.cleanPath((String)cleanIncludedFilePath);
        cleanIncludedFilePath = cleanIncludedFilePath.replaceFirst("^(\\.\\./)*", "");
        return cleanIncludedFilePath;
    }

    private String getDependenciesWithBuildSystemInfos(IncludeDirective includeDirective, @Nullable CompilationCommand compilationCommand) {
        String fallbackDependencyTarget = CppTypeExtractor.getUnresolvedHeaderType(CppDependencyExtractor.cleanupIncludedFilePath(includeDirective.getIncludedFilePath()), this.settings.performCaseSensitiveHeaderResolution);
        if (compilationCommand == null) {
            return fallbackDependencyTarget;
        }
        Optional<String> resolvedIncludeUniformPath = Objects.requireNonNull(this.dependencyExtractionIndexes.fileIncludeLookup).resolveIncludeToUniformPathWithCStandardLookup(includeDirective, this.uniformPath, compilationCommand.getIncludePathDetail().getResolvedIncludeSearchPaths(), this.settings.performCaseSensitiveHeaderResolution);
        if (resolvedIncludeUniformPath.isEmpty()) {
            return fallbackDependencyTarget;
        }
        String potentialType = CppTypeExtractor.getResolvedHeaderType(resolvedIncludeUniformPath.get(), this.settings.performCaseSensitiveHeaderResolution);
        if (this.typeLookupEnvironment.isKnownType(potentialType)) {
            return potentialType;
        }
        return fallbackDependencyTarget;
    }
}

